/*
 * Decompiled with CFR 0.152.
 */
package opale.module2d.noyau2d;

import opale.module2d.noyau2d.CoordSystem;
import opale.module2d.noyau2d.OIJ;
import opale.module2d.noyau2d.OIJException;

public class LinLinCS
extends CoordSystem {
    private double stepX;
    private double stepY;
    private double originX;
    private double originY;

    public LinLinCS(int n, int n2, int n3, int n4) {
        this.setSize(n, n2, n3, n4);
        try {
            this.oij = new OIJ(null, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0);
            this.autoadjust();
        }
        catch (OIJException oIJException) {}
    }

    public LinLinCS(OIJ oIJ, int n, int n2, int n3, int n4) {
        this.setSize(n, n2, n3, n4);
        this.setOIJ(oIJ);
        this.autoadjust();
    }

    public final int X(double d, double d2) {
        return (int)(this.originX + d * this.stepX * this.oij.I[0] + d2 * this.stepY * this.oij.J[0]);
    }

    public final int Y(double d, double d2) {
        return (int)(this.originY - d * this.stepX * this.oij.I[1] - d2 * this.stepY * this.oij.J[1]);
    }

    public void autoadjust() {
        this.stepX = (double)this.width / (this.xmax - this.xmin);
        this.stepY = (double)this.height / (this.ymax - this.ymin);
        this.originX = (int)((double)this.borderX - this.xmin * this.stepX);
        this.originY = (int)((double)this.borderY + this.ymax * this.stepY);
    }

    public final double normSq(double d, double d2) {
        return this.oij.normSq(d, d2);
    }

    public void normadjust() {
        this.stepX = this.stepY = Math.min((double)this.width / (this.xmax - this.xmin), (double)this.height / (this.ymax - this.ymin));
        this.width = (int)((this.xmax - this.xmin) * this.stepX);
        this.height = (int)((this.ymax - this.ymin) * this.stepX);
        this.originX = (int)((double)this.borderX - this.xmin * this.stepX);
        this.originY = (int)((double)this.borderY + this.ymax * this.stepY);
    }

    public final double xfromXY(int n, int n2) {
        return this.oij.oriX + (((double)n - this.originX) * this.oij.J[1] - ((double)n2 - this.originY) * this.oij.J[0]) / (this.stepX * (this.oij.I[0] * this.oij.J[1] - this.oij.I[1] * this.oij.J[0]));
    }

    public final double yfromXY(int n, int n2) {
        return this.oij.oriY + (((double)n2 - this.originY) * this.oij.I[0] - ((double)n - this.originX) * this.oij.I[1]) / (this.stepY * (-this.oij.I[0] * this.oij.J[1] + this.oij.I[1] * this.oij.J[0]));
    }
}

