<?php

/* Copyright (C) 2015, 2017 David MAURER david-maurer@netdefi.com */

/*
This file is part of "Online dating web site".

    "Online dating web site" is free software:
    you can redistribute it and/or modify it
    under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    "Online dating web site" is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with "Online dating web site", see the file COPYING.LESSER.
    If not, see <http://www.gnu.org/licenses/>.
*/



/******************************************************************************/
/* purpose : to verify that the PHP script was queried                        */
/*           through the HTTPS protocol.                                      */
/*                                                                            */
/* objectif : vérifier que le script PHP a été demandé                        */
/*            par le protocole HTTPS.                                         */
/******************************************************************************/

// empty()  Determine whether a variable is empty
if ( empty($_SERVER["HTTPS"]) ):

	// header()  Send a raw HTTP header
	header("location: https://" . $_SERVER["HTTP_HOST"] . $_SERVER["PHP_SELF"]);

endif;



/******************************************************************************/
/* purpose : to create a session, to store the values of the profile of a     */
/*           visitor, the time of his visit.                                  */
/*                                                                            */
/* objectif : créer une session, pour stocker les valeurs du profil d'un      */
/*            visiteur, le temps de sa visite.                                */
/******************************************************************************/

// session_start()  Start new or resume existing session
session_start();



/******************************************************************************/
/* purpose : to include the configuration files "settings.php"                */
/*           and the function library "functions.php                          */
/*                                                                            */
/* objectif : inclure le fichiers de configuration "settings.php"             */
/*            et la bibliothèque de fonctions "functions.php                  */
/******************************************************************************/

// require_once()  Includes and evaluates the specified file, check if the file has already been included
require_once("includes/settings.php");

// require_once()  Includes and evaluates the specified file, check if the file has already been included
require_once("includes/functions.php");



/******************************************************************************/
/* purpose : to create a cookie to retain the manual choice of the language   */
/*           of the website, choice made via the form "language"              */
/*                                                                            */
/* objectif : créer un cookie pour retenir le choix manuel de la langue       */
/*            du site web, choix fait via le formulaire "langage"             */
/******************************************************************************/

// filter_has_var()  Checks if variable of specified type exists
if ( filter_has_var(INPUT_POST, "choice_of_language") && filter_has_var(INPUT_POST, "language") ):

	// filter_input()  Gets a specific external variable by name and optionally filters it
	$filter_result = filter_input(INPUT_POST, "language", FILTER_SANITIZE_STRING);

	if ( ! $filter_result ):

		$error[] = _("Error, the value of the chosen language is invalid.");

	elseif ( $filter_result == "fr_FR" || $filter_result == "en" ):

		// setcookie()  Send a cookie
		setcookie("language", $filter_result, time() + 3600 * 24 * 365, "/", $_SERVER["HTTP_HOST"], true, true);

		$_COOKIE["language"] = $filter_result;

	else:

		$error[] = _("Error, the language chosen is not supported.");

	endif;

endif;



/******************************************************************************/
/* purpose : to select the language of the website                            */
/*                                                                            */
/* objectif : sélectionner la langue du site web                              */
/******************************************************************************/

// select_a_language()  Select a language
$language = select_a_language(array("fr", "fr-FR"), "en");

if ( $language != "en" ):

	$language = ($language == "fr" || $language == "fr-FR") ? "fr_FR" : $language;
	$language = $language . ".utf-8";
	$encoding = "utf-8";
	$domain = "messages";

	// setlocale()  Set locale information
	setlocale(LC_MESSAGES, $language);

	// bindtextdomain()  Sets the path for a domain
	bindtextdomain($domain, LOCALE_DIRECTORY);

	// bind_textdomain_codeset()  Specify the character encoding in which the messages from the DOMAIN message catalog will be returned
	bind_textdomain_codeset($domain, $encoding);

	// textdomain()  Sets the default domain
	textdomain($domain);

endif;
?>
<!DOCTYPE html>
<html>
	<head>
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<meta http-equiv="content-type" content="text/html;charset=utf-8">
		<link rel="icon" type="image/png" href="images/logo.png">
		<title><?php print $_SERVER["HTTP_HOST"]; ?> <?php print _("serious dating website"); ?></title>
		<meta name="keywords" content="<?php print _("dating site,dating,love,bachelor,find love,ad,chat"); ?>">
		<meta name="description" content="<?php print _("In search of love? Bachelors are waiting for you to meet you."); ?>">
		<link rel="stylesheet" type="text/css" href="css/mystyle.css">
	</head>
	<body>
		<div id="cookies">
			<?php print _("This website is likely to deposit 2 cookies on your device."); ?> <a href="pages/cookies.php"><?php print _("Learn more."); ?></a>
		</div>
		<?php
		// isset()  Determine if a variable is set and is not NULL
		if ( isset($error) ):

			print "<div class=\"error\">";

			foreach( $error as $value ):

				print "<p>" . $value . "</p>";

			endforeach;

			print "</div>";

		endif;
		?>
		<div class="layout">
			<div id="heading">
				<div id="logo">
					<img src="images/logo.png">
				</div><!-- logo -->
				<h1><?php print _("I welcome you to"); ?> <a href="https://<?php print $_SERVER["HTTP_HOST"]; ?>"><?php print $_SERVER["HTTP_HOST"]; ?></a>,</h1>
				<h2><?php print _("this dating website was created for people wishing to build a serious long-term relationship or even a wedding."); ?></h2>
			</div><!-- heading -->
			<div id="navigation">
				<form method="post">
					<?php print _("Language"); ?>&nbsp;:
					<select name="language">
						<option value="en"<?php if ( $language == "en" ): print " selected"; endif; ?>>English</option>
						<option value="fr_FR"<?php if ( $language == "fr_FR.utf-8" ): print " selected"; endif; ?>>Français</option>
					</select>
					<input type="submit" name="choice_of_language" value="<?php print _("Validate"); ?>">
				</form>
				<br>
				<a href="pages/sign_in.php" class="not_underlined"><input type="submit" value="&nbsp;&nbsp;&nbsp;&nbsp;<?php print _("Sign in"); ?>&nbsp;&nbsp;&nbsp;&nbsp;"></a> |
				<a href="pages/sign_up.php" class="not_underlined"><input type="submit" value="&nbsp;&nbsp;&nbsp;&nbsp;<?php print _("Sign up"); ?>&nbsp;&nbsp;&nbsp;&nbsp;"></a> |
				<a href="#"><?php print _("Home"); ?></a>
			</div><!-- navigation -->
			<div id="image">
			</div><!-- image -->
			<div id="footer">
				<a href="pages/cookies.php"><?php print _("Cookies"); ?></a> |
				<a href="pages/legal_informations.php"><?php print _("Legal informations"); ?></a> |
				<a href="pages/terms_of_sale.php"><?php print _("Terms of sale"); ?></a>
			</div><!-- footer -->
		</div><!-- layout -->
	</body>
</html>
