<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Welcome extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
	public function index()
	{
		$this->load->database();
		$this->load->helper(array('cookie', 'form', 'language', 'url'));
		$this->load->library(array('form_validation', 'mylibrary', 'session'));

		if ( $this->input->post('choice_of_language') )
			$this->form_validation->set_rules('language', 'Language', 'callback_language_check');

		if ( $this->input->post('choice_of_language') && $this->form_validation->run() )
		{
			$language = $this->input->post('language');
			set_cookie('language', $language, time() + 3600 * 24 * 365, $_SERVER['HTTP_HOST'], '/', '', true, true);
		}
		else $language = $this->mylibrary->select_a_language(array('fr-FR', 'fr', 'en'), 'en');

		if ( $language == 'fr-FR' || $language == 'fr' )
		{
			$language = 'fr-FR';
			$this->lang->load('french_lang', 'french');
		}
    	else $this->lang->load('english_lang', 'english');

		$navigation_data['language'] = $language;
		$navigation_data['home'] = true;

		if ( $this->session->has_userdata('member_id') )
		{
			$sql = 'SELECT timezone FROM members WHERE id = ? LIMIT 1';
			$query = $this->db->query($sql, $this->session->member_id);

			foreach ( $query->result() as $row )
			{
				$timezone = $row->timezone;
			}

			$datetime_objet = new DateTime('now', new DateTimeZone($timezone));
			$datetime = $datetime_objet->format('Y-m-d H:i:s');

			$sql = 'UPDATE members SET last_connection = ? WHERE id = ?';
			$this->db->query($sql, array($datetime, $this->session->member_id));
		}

		$this->load->view('templates/header');
		$this->load->view('templates/heading_cookies');
		$this->load->view('templates/heading');
		$this->load->view('templates/navigation', $navigation_data);
		$this->load->view('welcome_message');
		$this->load->view('templates/footer');
	}

	public function language_check($str)
	{
		if ( $str == 'fr-FR' || $str == 'en' )
			return true;
		else
			return false;
	}

	public function en()
	{
        $this->load->database();
		$this->load->helper(array('cookie', 'form', 'language', 'url'));
		$this->load->library(array('form_validation', 'mylibrary', 'session'));

        $language = 'en';
        set_cookie('language', $language, time() + 3600 * 24 * 365, $_SERVER['HTTP_HOST'], '/', '', true, true);
    	$this->lang->load('english_lang', 'english');

		$navigation_data['language'] = $language;
		$navigation_data['home'] = true;

		if ( $this->session->has_userdata('member_id') )
		{
			$sql = 'SELECT timezone FROM members WHERE id = ? LIMIT 1';
			$query = $this->db->query($sql, $this->session->member_id);

			foreach ( $query->result() as $row )
			{
				$timezone = $row->timezone;
			}

			$datetime_objet = new DateTime('now', new DateTimeZone($timezone));
			$datetime = $datetime_objet->format('Y-m-d H:i:s');

			$sql = 'UPDATE members SET last_connection = ? WHERE id = ?';
			$this->db->query($sql, array($datetime, $this->session->member_id));
		}

		$this->load->view('templates/header');
		$this->load->view('templates/heading_cookies');
		$this->load->view('templates/heading');
		$this->load->view('templates/navigation', $navigation_data);
		$this->load->view('welcome_message');
		$this->load->view('templates/footer');
	}

	public function fr()
	{
        $this->load->database();
		$this->load->helper(array('cookie', 'form', 'language', 'url'));
		$this->load->library(array('form_validation', 'mylibrary', 'session'));
		
        $language = 'fr-FR';
        set_cookie('language', $language, time() + 3600 * 24 * 365, $_SERVER['HTTP_HOST'], '/', '', true, true);
        $this->lang->load('french_lang', 'french');

		$navigation_data['language'] = $language;
		$navigation_data['home'] = true;

		if ( $this->session->has_userdata('member_id') )
		{
			$sql = 'SELECT timezone FROM members WHERE id = ? LIMIT 1';
			$query = $this->db->query($sql, $this->session->member_id);

			foreach ( $query->result() as $row )
			{
				$timezone = $row->timezone;
			}

			$datetime_objet = new DateTime('now', new DateTimeZone($timezone));
			$datetime = $datetime_objet->format('Y-m-d H:i:s');

			$sql = 'UPDATE members SET last_connection = ? WHERE id = ?';
			$this->db->query($sql, array($datetime, $this->session->member_id));
		}

		$this->load->view('templates/header');
		$this->load->view('templates/heading_cookies');
		$this->load->view('templates/heading');
		$this->load->view('templates/navigation', $navigation_data);
		$this->load->view('welcome_message');
		$this->load->view('templates/footer');
	}

	public function cookies()
	{
		$this->load->database();
		$this->load->helper(array('cookie', 'form', 'language', 'url'));
		$this->load->library(array('form_validation', 'mylibrary', 'session'));

		if ( $this->input->post('choice_of_language') )
			$this->form_validation->set_rules('language', 'Language', 'callback_language_check');

		if ( $this->input->post('choice_of_language') && $this->form_validation->run() )
		{
			$language = $this->input->post('language');
			set_cookie('language', $language, time() + 3600 * 24 * 365, $_SERVER['HTTP_HOST'], '/', '', true, true);
		}
		else $language = $this->mylibrary->select_a_language(array('fr-FR', 'fr', 'en'), 'en');

		if ( $language == 'fr-FR' || $language == 'fr' )
		{
			$language = 'fr-FR';
			$this->lang->load('french_lang', 'french');
		}
    	else $this->lang->load('english_lang', 'english');

		$navigation_data['language'] = $language;

		if ( $this->session->has_userdata('member_id') )
		{
			$sql = 'SELECT timezone FROM members WHERE id = ? LIMIT 1';
			$query = $this->db->query($sql, $this->session->member_id);

			foreach ( $query->result() as $row )
			{
				$timezone = $row->timezone;
			}

			$datetime_objet = new DateTime('now', new DateTimeZone($timezone));
			$datetime = $datetime_objet->format('Y-m-d H:i:s');

			$sql = 'UPDATE members SET last_connection = ? WHERE id = ?';
			$this->db->query($sql, array($datetime, $this->session->member_id));
		}

		$this->load->view('templates/header');
		$this->load->view('templates/navigation', $navigation_data);
		$this->load->view('cookies');
		$this->load->view('templates/footer');
	}

	public function protection_of_personal_data()
	{
		$this->load->database();
		$this->load->helper(array('cookie', 'form', 'language', 'url'));
		$this->load->library(array('form_validation', 'mylibrary', 'session'));

		if ( $this->input->post('choice_of_language') )
			$this->form_validation->set_rules('language', 'Language', 'callback_language_check');

		if ( $this->input->post('choice_of_language') && $this->form_validation->run() )
		{
			$language = $this->input->post('language');
			set_cookie('language', $language, time() + 3600 * 24 * 365, $_SERVER['HTTP_HOST'], '/', '', true, true);
		}
		else $language = $this->mylibrary->select_a_language(array('fr-FR', 'fr', 'en'), 'en');

		if ( $language == 'fr-FR' || $language == 'fr' )
		{
			$language = 'fr-FR';
			$this->lang->load('french_lang', 'french');
		}
    	else $this->lang->load('english_lang', 'english');

		$navigation_data['language'] = $language;

		if ( $this->session->has_userdata('member_id') )
		{
			$sql = 'SELECT timezone FROM members WHERE id = ? LIMIT 1';
			$query = $this->db->query($sql, $this->session->member_id);

			foreach ( $query->result() as $row )
			{
				$timezone = $row->timezone;
			}

			$datetime_objet = new DateTime('now', new DateTimeZone($timezone));
			$datetime = $datetime_objet->format('Y-m-d H:i:s');

			$sql = 'UPDATE members SET last_connection = ? WHERE id = ?';
			$this->db->query($sql, array($datetime, $this->session->member_id));
		}

		$this->load->view('templates/header');
		$this->load->view('templates/navigation', $navigation_data);
		$this->load->view('protection_of_personal_data');
		$this->load->view('templates/footer');
	}

	public function legal_notice()
	{
		$this->load->database();
		$this->load->helper(array('cookie', 'form', 'language', 'url'));
		$this->load->library(array('form_validation', 'mylibrary', 'session'));

		if ( $this->input->post('choice_of_language') )
			$this->form_validation->set_rules('language', 'Language', 'callback_language_check');

		if ( $this->input->post('choice_of_language') && $this->form_validation->run() )
		{
			$language = $this->input->post('language');
			set_cookie('language', $language, time() + 3600 * 24 * 365, $_SERVER['HTTP_HOST'], '/', '', true, true);
		}
		else $language = $this->mylibrary->select_a_language(array('fr-FR', 'fr', 'en'), 'en');

		if ( $language == 'fr-FR' || $language == 'fr' )
		{
			$language = 'fr-FR';
			$this->lang->load('french_lang', 'french');
		}
    	else $this->lang->load('english_lang', 'english');

		$navigation_data['language'] = $language;

		if ( $this->session->has_userdata('member_id') )
		{
			$sql = 'SELECT timezone FROM members WHERE id = ? LIMIT 1';
			$query = $this->db->query($sql, $this->session->member_id);

			foreach ( $query->result() as $row )
			{
				$timezone = $row->timezone;
			}

			$datetime_objet = new DateTime('now', new DateTimeZone($timezone));
			$datetime = $datetime_objet->format('Y-m-d H:i:s');

			$sql = 'UPDATE members SET last_connection = ? WHERE id = ?';
			$this->db->query($sql, array($datetime, $this->session->member_id));
		}

		$this->load->view('templates/header');
		$this->load->view('templates/navigation', $navigation_data);
		$this->load->view('legal_informations');
		$this->load->view('templates/footer');
	}

	public function free_software()
	{
		$this->load->database();
		$this->load->helper(array('cookie', 'form', 'language', 'url'));
		$this->load->library(array('form_validation', 'mylibrary', 'session'));

		if ( $this->input->post('choice_of_language') )
			$this->form_validation->set_rules('language', 'Language', 'callback_language_check');

		if ( $this->input->post('choice_of_language') && $this->form_validation->run() )
		{
			$language = $this->input->post('language');
			set_cookie('language', $language, time() + 3600 * 24 * 365, $_SERVER['HTTP_HOST'], '/', '', true, true);
		}
		else $language = $this->mylibrary->select_a_language(array('fr-FR', 'fr', 'en'), 'en');

		if ( $language == 'fr-FR' || $language == 'fr' )
		{
			$language = 'fr-FR';
			$this->lang->load('french_lang', 'french');
		}
    	else $this->lang->load('english_lang', 'english');

		$navigation_data['language'] = $language;

		if ( $this->session->has_userdata('member_id') )
		{
			$sql = 'SELECT timezone FROM members WHERE id = ? LIMIT 1';
			$query = $this->db->query($sql, $this->session->member_id);

			foreach ( $query->result() as $row )
			{
				$timezone = $row->timezone;
			}

			$datetime_objet = new DateTime('now', new DateTimeZone($timezone));
			$datetime = $datetime_objet->format('Y-m-d H:i:s');

			$sql = 'UPDATE members SET last_connection = ? WHERE id = ?';
			$this->db->query($sql, array($datetime, $this->session->member_id));
		}

		$this->load->view('templates/header');
		$this->load->view('templates/navigation', $navigation_data);
		$this->load->view('free_software');
		$this->load->view('templates/footer');
	}

	public function register()
	{
		$this->load->database();
		$this->load->helper(array('cookie', 'form', 'language', 'url'));
		$this->load->library(array('form_validation', 'mylibrary', 'session'));

		if ( $this->input->post('choice_of_language') )
			$this->form_validation->set_rules('language', 'Language', 'callback_language_check');

		if ( $this->input->post('choice_of_language') && $this->form_validation->run() )
		{
			$language = $this->input->post('language');
			set_cookie('language', $language, time() + 3600 * 24 * 365, $_SERVER['HTTP_HOST'], '/', '', true, true);
		}
		else $language = $this->mylibrary->select_a_language(array('fr-FR', 'fr', 'en'), 'en');

		if ( $language == 'fr-FR' || $language == 'fr' )
		{
			$language = 'fr-FR';
			$this->lang->load('french_lang', 'french');
		}
    	else $this->lang->load('english_lang', 'english');

		$navigation_data['language'] = $language;
		$navigation_data['register'] = true;

		if ( ! $this->session->has_userdata('register_form') )
			$this->session->register_form = 1;

		if ( $this->input->post('register_part1') )
		{
			$this->form_validation->set_rules('gender', 'Gender', 'callback_gender_check');
			$this->form_validation->set_rules('look_for', 'look for', 'callback_look_for_check');
			$this->form_validation->set_rules('certify_and_agree', 'Certify and agree', 'required', array('required' => lang('certify_and_agree')));
			$this->form_validation->set_rules('certify', 'Certify', 'required', array('required' => lang('certify')));
			$this->form_validation->set_rules('certify_money', 'Certify money', 'required', array('required' => lang('certify_money')));

			if ( $this->form_validation->run() )
			{
				$this->session->gender = $this->input->post('gender');
				$this->session->look_for = $this->input->post('look_for');
				$this->session->certify_and_agree = 1;
				$this->session->certify = 1;
				$this->session->certify_money = 1;
				$this->session->register_form = 2;
			}
		}

		if ( $this->input->post('register_part2') )
		{
			$this->form_validation->set_rules('year', 'Year', 'callback_year_check');
			$this->form_validation->set_rules('month', 'Month', 'callback_month_check');
			$this->form_validation->set_rules('day', 'Day', 'callback_day_check');

			if ( $this->form_validation->run() )
			{
				$this->session->year = $this->input->post('year');
				$this->session->month = $this->input->post('month');
				$this->session->day = $this->input->post('day');
				$this->session->register_form = 3;
      		}
		}

		if ( $this->input->post('register_part3_continent') )
		{
			$this->form_validation->set_rules('continent', 'Continent', 'callback_continent_check');

			if ( $this->form_validation->run() )
			{
				$this->session->continent = $this->input->post('continent');
				$this->session->unset_userdata(array('country', 'city'));
      		}
		}

		if ( $this->input->post('register_part3_country') )
		{
			$this->form_validation->set_rules('country', 'Country', 'callback_country_check');

			if ( $this->form_validation->run() )
			{
				$this->session->country = $this->input->post('country');
				$this->session->unset_userdata('city');
      		}
		}

		if ( $this->input->post('register_part3') )
		{
			$this->form_validation->set_rules('city', 'City', 'callback_city_check');

			if ( $this->form_validation->run() )
			{
				$this->session->city = $this->input->post('city');
				$this->session->register_form = 4;
      		}
		}

		if ( $this->input->post('register_part4') )
		{

			if ( ! $this->session->has_userdata('picture') )
			{

				if ( $this->security->xss_clean($this->input->post('picture'), TRUE) === FALSE )
				{
					// file failed the XSS test
					$register_form4_data['errors'][] = lang('image_xss_test_failed');
					
				}
				else
				{
					$config['upload_path']          = './uploads/';
				    $config['allowed_types']        = 'gif|jpeg|jpg|png';
				    $config['max_size']             = $this->mylibrary->return_kilobytes(ini_get('upload_max_filesize'));
				    $config['max_width']            = 1024;
				    $config['max_height']           = 768;

				    $this->load->library('upload', $config);

				    if ( ! $this->upload->do_upload('picture') )
				    {
				            $register_form4_data['errors'][] = $this->upload->display_errors();
				    }
				    else
				    {
				            $this->session->picture = $this->upload->data()['file_name'];
							$this->session->register_form = 5;
				    }
				}
			}

			$description = $this->security->xss_clean($this->input->post('description'));

			if ( ! strlen($description) )
			{
				$register_form4_data['errors'][] = lang('register_form4_8');
				$this->session->register_form = 4;
			}
			elseif ( strlen($description) > 255 )
			{
				$register_form4_data['errors'][] = lang('register_form4_9');
				$this->session->register_form = 4;
			}
			else
			{
				$this->session->description = $description;
				if ($this->session->has_userdata('picture'))				
					$this->session->register_form = 5;
			}
		}


		if ( $this->input->post('delete_picture') )
		{
			unlink('./uploads/'.$this->session->picture);
			$this->session->unset_userdata('picture');
		}

		if ( $this->input->post('register_part5') )
		{
			$this->form_validation->set_rules('non_smoker', 'Non-smoker', 'callback_non_smoker_check');
			$this->form_validation->set_rules('religion', 'Religion', 'callback_religion_check');

			if ( $this->form_validation->run() )
			{
				$this->session->non_smoker = $this->input->post('non_smoker');
				$this->session->religion = $this->input->post('religion');
				$this->session->register_form = 6;
			}
		}

		if ( $this->input->post('register_part6') )
		{
			$this->form_validation->set_rules('pseudonym', 'Pseudonym', 'callback_pseudonym_check');
			$this->form_validation->set_rules('email', 'Email', 'callback_email_check');
			$this->form_validation->set_rules('password', 'Password', 'callback_password_check');
			$this->form_validation->set_rules('password_again', 'Password again', 'callback_password_again_check');

			if ( $this->form_validation->run() )
			{
				$sql = 'SELECT name FROM countries WHERE id = ? LIMIT 1';
				$query = $this->db->query($sql, $this->session->country);

				$this->load->library('mygeoip2');

				foreach ( $query->result() as $row )
				{
					if ( stristr($row->name, $this->mygeoip2->getState()) === false )
						$register_trust = 0;
					else
						$register_trust = 1;
				}

				$data = array(
					'gender' => $this->session->gender,
					'look_for' => $this->session->look_for,
					'birthdate' => $this->session->year.'-'.$this->session->month.'-'.$this->session->day,
					'continent' => $this->session->continent,
					'country' => $this->session->country,
					'city' => $this->session->city,
					'picture' => $this->session->picture,
					'description' => $this->session->description,
					'non_smoker' => $this->session->non_smoker,
					'religion' => $this->session->religion,
					'pseudonym' => $this->input->post('pseudonym'),
					'email' => $this->input->post('email'),
					'password' => password_hash($this->input->post('password'), PASSWORD_DEFAULT),
					'register_ip_address' => $this->input->ip_address(),
					'register_state' => $this->mygeoip2->getState(),
					'register_city' => $this->mygeoip2->getCity(),
					'register_trust' => $register_trust,
					'timezone' => $this->mygeoip2->getTimezone()
				);

				if ( $this->db->insert('members', $data) )
				{
					if ( $register_trust == 1 )
						$this->session->member_id = $this->db->insert_id();
					$array_items = array('gender', 'look_for', 'year', 'month', 'day', 'continent', 'country', 'city', 'picture', 'description', 'non_smoker', 'religion', 'register_form', 'certify_and_agree', 'certify', 'certify_money');
					$this->session->unset_userdata($array_items);
					redirect('welcome/research');
				}
			}
		}

		if ( $this->input->post('return_register_part1') )
			$this->session->register_form = 1;

		if ( $this->input->post('return_register_part2') )
			$this->session->register_form = 2;

		if ( $this->input->post('return_register_part3') )
			$this->session->register_form = 3;

		if ( $this->input->post('return_register_part4') )
			$this->session->register_form = 4;

		if ( $this->input->post('return_register_part5') )
			$this->session->register_form = 5;

		$this->load->view('templates/header');
		$this->load->view('templates/navigation', $navigation_data);
		$this->load->view('register_contents_begin');

		if ( $this->session->register_form == 1 )
			$this->load->view('register_form1');
		elseif ( $this->session->register_form == 2 )
			$this->load->view('register_form2');
		elseif ( $this->session->register_form == 3 )
		{
			$query = $this->db->query('SELECT id, name FROM continents ORDER BY name');
         	$register_form3_data['continents'] = $query->result();

			if ( $this->session->has_userdata('continent') )
			{
				$sql = 'SELECT id, name FROM countries WHERE continent_id = ? ORDER BY name';
				$query = $this->db->query($sql, $this->session->continent);
				$register_form3_data['countries'] = $query->result();
			}

			if ( $this->session->has_userdata('continent') && $this->session->has_userdata('country') )
			{
				$sql = 'SELECT id, asciiname, name, LEFT(alternatenames, 40) as alternatenames FROM cities WHERE country_id = ? ORDER BY asciiname';
				$query = $this->db->query($sql, $this->session->country);
				$register_form3_data['cities'] = $query->result();
			}

			$this->load->view('register_form3', $register_form3_data);
		}
		elseif ( $this->session->register_form == 4 )
		{
			if ( ! isset($register_form4_data['errors']) )
				$register_form4_data['errors'][] = null;

			$this->load->view('register_form4', $register_form4_data);
		}
		elseif ( $this->session->register_form == 5 )
			$this->load->view('register_form5');
		elseif ( $this->session->register_form == 6 )
			$this->load->view('register_form6');

		$this->load->view('register_contents_end');
		$this->load->view('templates/footer');
	}

	public function gender_check($str)
	{
		if ( $str == 1 || $str == 2 )
			return true;
		else
		{
			$this->form_validation->set_message('gender_check', lang('gender_check'));
			return false;
		}
	}

	public function look_for_check($str)
	{
		if ( $str == 1 || $str == 2 )
			return true;
		else
		{
			$this->form_validation->set_message('look_for_check', lang('look_for_check'));
			return false;
		}
	}

	public function year_check($str)
	{
		if ( $str <= date('Y') - 18 && $str >= date('Y') - 151 )
			return true;
		else
		{
			$this->form_validation->set_message('year_check', lang('year_check'));
			return false;
		}
	}

	public function month_check($str)
	{
		if ( $str >= 1 && $str <= 12 )
			return true;
		else
		{
			$this->form_validation->set_message('month_check', lang('month_check'));
			return false;
		}
	}

	public function day_check($str)
	{
		@ $days_in_month = cal_days_in_month(CAL_GREGORIAN, $this->input->post('month'), $this->input->post('year'));

		if ( ! ($days_in_month >=1 && $days_in_month <= 31) )
			$days_in_month = 31;

		if ( $str >= 1 && $str <= $days_in_month )
			return true;
		else
		{
			$this->form_validation->set_message('day_check', lang('day_check'));
			return false;
		}
	}

	public function continent_check($str)
	{
		if ( $str >= 1 && $str <= 7 )
			return true;
		else
		{
			$this->form_validation->set_message('continent_check', lang('continent_check'));
			return false;
		}
	}

	public function country_check($str)
	{
		$sql = 'SELECT 1 FROM countries WHERE id = ? AND continent_id = ? LIMIT 1';
		$query = $this->db->query($sql, array($str, $this->session->continent));

		if ( $query->num_rows() )
			return true;
		else
		{
			$this->form_validation->set_message('country_check', lang('country_check'));
			return false;
		}
	}

	public function city_check($str)
	{
		$sql = 'SELECT 1 FROM cities WHERE id = ? AND country_id = ? LIMIT 1';
		$query = $this->db->query($sql, array($str, $this->session->country));

		if ( $query->num_rows() )
			return true;
		else
		{
			$this->form_validation->set_message('city_check', lang('city_check'));
			return false;
		}
	}

	public function non_smoker_check($str)
	{
		if ( $str >= 1 && $str <= 2 )
			return true;
		else
		{
			$this->form_validation->set_message('non_smoker_check', lang('non_smoker_check'));
			return false;
		}
	}

	public function religion_check($str)
	{
		if ( $str >= 1 && $str <= 15 )
			return true;
		else
		{
			$this->form_validation->set_message('religion_check', lang('religion_check'));
			return false;
		}
	}

	public function pseudonym_check($str)
	{
		if ( strlen($str) )
		{
			$sql = 'SELECT 1 FROM members WHERE pseudonym = ? LIMIT 1';
			$query = $this->db->query($sql, $str);

			if ( $query->num_rows() )
			{
				$this->form_validation->set_message('pseudonym_check', lang('pseudonym_check2'));
				return false;
			}
			else
				return true;
		}
		else
		{
			$this->form_validation->set_message('pseudonym_check', lang('pseudonym_check'));
			return false;
		}
	}

	public function email_check($str)
	{
		$this->load->helper('email');

		if ( valid_email($str) )
		{
			$sql = 'SELECT 1 FROM members WHERE email = ? LIMIT 1';
			$query = $this->db->query($sql, $str);

			if ( $query->num_rows() )
			{
				$this->form_validation->set_message('email_check', lang('email_check2'));
				return false;
			}
			else
				return true;
		}
		else
		{
			$this->form_validation->set_message('email_check', lang('email_check'));
			return false;
		}
	}

	public function password_check($str)
	{
		$mystrlen = strlen($str);

		if ( $mystrlen >= 10 && $mystrlen <= 1024 )
		{
			$check = true;

			if ( ! preg_match("#[0-9]+#", $str) || ! preg_match("#[a-z]+#", $str) || ! preg_match("#[A-Z]+#", $str) ) {
				$check = false;
			}

			if ($check)
				return true;
			else
			{
				$this->form_validation->set_message('password_check', lang('password_check2'));
				return false;
			}

		}		
		else
		{
			$this->form_validation->set_message('password_check', lang('password_check'));
			return false;
		}
	}

	public function password_again_check($str)
	{
		if ( ! strcmp($str, $this->input->post('password')) )
			return true;
		else
		{
			$this->form_validation->set_message('password_again_check', lang('password_again_check'));
			return false;
		}
	}

	public function research($pagination = null)
	{
		$this->load->database();
		$this->load->helper(array('cookie', 'form', 'language', 'url'));
		$this->load->library(array('form_validation', 'mylibrary', 'pagination', 'session'));

		if ( $this->input->post('choice_of_language') )
			$this->form_validation->set_rules('language', 'Language', 'callback_language_check');

		if ( $this->input->post('choice_of_language') && $this->form_validation->run() )
		{
			$language = $this->input->post('language');
			set_cookie('language', $language, time() + 3600 * 24 * 365, $_SERVER['HTTP_HOST'], '/', '', true, true);
		}
		else $language = $this->mylibrary->select_a_language(array('fr-FR', 'fr', 'en'), 'en');

		if ( $language == 'fr-FR' || $language == 'fr' )
		{
			$language = 'fr-FR';
			$this->lang->load('french_lang', 'french');
		}
    	else $this->lang->load('english_lang', 'english');

		$navigation_data['language'] = $language;
		$navigation_data['research'] = true;

		if ( ! $this->session->has_userdata('member_id') )
			redirect('/welcome/log_in');

		$sql = 'SELECT timezone FROM members WHERE id = ? LIMIT 1';
		$query = $this->db->query($sql, $this->session->member_id);

		foreach ( $query->result() as $row )
		{
			$timezone = $row->timezone;
		}

		$datetime_objet = new DateTime('now', new DateTimeZone($timezone));
		$datetime = $datetime_objet->format('Y-m-d H:i:s');

		$sql = 'UPDATE members SET last_connection = ? WHERE id = ?';
		$this->db->query($sql, array($datetime, $this->session->member_id));

		$sql = 'SELECT members.gender, members.look_for, members.birthdate, cities.name as city_name, cities.latitude, cities.longitude FROM members INNER JOIN cities ON members.city = cities.id WHERE members.id = ? LIMIT 1';
		$query = $this->db->query($sql, $this->session->member_id);

		foreach( $query->result() as $row )
		{
			$research_data['look_for'] = $row->look_for;
			$research_data['age'] = (int) ((time() - strtotime($row->birthdate)) / (3600 * 24 * 365));
			$research_data['city'] = $row->city_name;
			$gender = $row->gender;
			$latitude = $row->latitude;
			$longitude = $row->longitude;
		}

		if ( ! (is_numeric($pagination) && $pagination >= 0) )
			$pagination = 0;

		$result_data['members_found'] = null;

		if ( $this->input->post('research') )
		{
			$this->form_validation->set_rules('age_beginning', 'Age of beginning', 'callback_age_beginning_check');
			$this->form_validation->set_rules('age_end', 'Age of end', 'callback_age_end_check');
			$this->form_validation->set_rules('distance', 'Distance', 'callback_distance_check');
			$this->form_validation->set_rules('last_connection', 'Last connection', 'callback_last_connection_check');

			if ( $this->form_validation->run() )
			{
				$this->session->age_beginning = $this->input->post('age_beginning');
				$this->session->age_end = $this->input->post('age_end');
				$this->session->distance = $this->input->post('distance');
				$this->session->last_connection = $this->input->post('last_connection');
			}
		}

		if ( $this->session->has_userdata('age_beginning') && $this->session->has_userdata('age_end') && $this->session->has_userdata('distance') && $this->session->has_userdata('last_connection') )
		{
			if( $this->session->last_connection == 1 )
				$last_connection = 5; // 5 minutes
			elseif ( $this->session->last_connection == 2 )
				$last_connection = 24 * 60; // 24 hours
			elseif ( $this->session->last_connection == 3 )
				$last_connection = 3 * 24 * 60; // 3 days
			elseif ( $this->session->last_connection == 4 )
				$last_connection = 7 * 24 * 60; // 1 week
			elseif ( $this->session->last_connection == 5 )
				$last_connection = 31 * 24 * 60; // approximately 1 month
			else
				$last_connection = 12 * 31 *24 * 60; // approximately 1 year

			// parameters : units, lat, lon, max_distance, gender, look_for, age_beginning, age_end, last_connection
			$sql = 'CALL number_of_closest_members_optimized(?, ?, ?, ?, ?, ?, ?, ?, ?)';

			if ( $navigation_data['language'] == 'fr-FR' )
				$data = array('km', $latitude, $longitude, $this->session->distance, $research_data['look_for'], $gender, $this->session->age_beginning, $this->session->age_end, $last_connection);
			else
				$data = array('miles', $latitude, $longitude, $this->session->distance, $research_data['look_for'], $gender, $this->session->age_beginning, $this->session->age_end, $last_connection);

			$query = $this->db->query($sql, $data);

			foreach( $query->result() as $row )
			{
				$config['total_rows'] = $row->number_of_members;
			}

			mysqli_next_result($this->db->conn_id);

			$config['base_url'] = site_url('welcome/research');
			$config['per_page'] = 10;
			$this->pagination->initialize($config);

			// parameters : units, lat, lon, max_distance, gender, look_for, age_beginning, age_end, last_connection, rows_limit, rows_offset
			$sql = 'CALL closest_members_optimized(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';

			if ( $navigation_data['language'] == 'fr-FR' )
				$data = array('km', $latitude, $longitude, $this->session->distance, $research_data['look_for'], $gender, $this->session->age_beginning, $this->session->age_end, $last_connection, $config['per_page'], $pagination);
			else
				$data = array('miles', $latitude, $longitude, $this->session->distance, $research_data['look_for'], $gender, $this->session->age_beginning, $this->session->age_end, $last_connection, $config['per_page'], $pagination);

			$query = $this->db->query($sql, $data);

			foreach( $query->result() as $row )
			{
				$result_data['members_found'][] = array(
					'id' => $row->id,
					'picture' => $row->picture,
					'pseudonym' => $row->pseudonym,
					'age' => (int) ((time() - strtotime($row->birthdate)) / (3600 * 24 * 365)),
					'continent' => $row->contient_name,
					'country' => $row->country_name,
					'city' => $row->city_name,
					'description' => $row->description,
					'distance' => $row->distance,
					'non_smoker' => $row->non_smoker,
					'religion' => $row->religion
				);
			}
		}

		$result_data['pagination'] = $pagination;
		$result_data['per_page'] = isset($config['per_page']) ? $config['per_page'] : 0;
		$result_data['total_rows'] = isset($config['total_rows']) ? $config['total_rows'] : 0;
		$result_data['pagination_links'] = $this->pagination->create_links();

		$this->load->view('templates/header');
		$this->load->view('templates/navigation', $navigation_data);
		$this->load->view('research', $research_data);
		$this->load->view('result', $result_data);
		$this->load->view('templates/footer');
	}

	public function age_beginning_check($str)
	{
		if ( $str > 17 && $str < 151 )
			return true;
		else
		{
			$this->form_validation->set_message('age_beginning_check', lang('age_beginning_check'));
			return false;
		}
	}

	public function age_end_check($str)
	{
		if ( $str > 18 && $str < 151 )
		{
			if ( $str > $this->input->post('age_beginning') )
				return true;
			else
			{
				$this->form_validation->set_message('age_end_check', lang('age_end_check2'));
				return false;
			}
		}
		else
		{
			$this->form_validation->set_message('age_end_check', lang('age_end_check'));
			return false;
		}
	}

	public function distance_check($str)
	{
		if ( $str > 9 && $str < 1001 )
			return true;
		else
		{
			$this->form_validation->set_message('distance_check', lang('distance_check'));
			return false;
		}
	}

	public function last_connection_check($str)
	{
		if ( $str > 0 && $str < 7 )
			return true;
		else
		{
			$this->form_validation->set_message('last_connection_check', lang('last_connection_check'));
			return false;
		}
	}

	public function send_message($id = null)
	{
		$this->load->database();
		$this->load->helper(array('cookie', 'form', 'language', 'url'));
		$this->load->library(array('form_validation', 'mylibrary', 'session'));

		if ( $this->input->post('choice_of_language') )
			$this->form_validation->set_rules('language', 'Language', 'callback_language_check');

		if ( $this->input->post('choice_of_language') && $this->form_validation->run() )
		{
			$language = $this->input->post('language');
			set_cookie('language', $language, time() + 3600 * 24 * 365, $_SERVER['HTTP_HOST'], '/', '', true, true);
		}
		else $language = $this->mylibrary->select_a_language(array('fr-FR', 'fr', 'en'), 'en');

		if ( $language == 'fr-FR' || $language == 'fr' )
		{
			$language = 'fr-FR';
			$this->lang->load('french_lang', 'french');
		}
    	else $this->lang->load('english_lang', 'english');

		$navigation_data['language'] = $language;

		if ( ! $this->session->has_userdata('member_id') )
			redirect('/welcome/log_in');

		$sql = 'SELECT timezone FROM members WHERE id = ? LIMIT 1';
		$query = $this->db->query($sql, $this->session->member_id);

		foreach ( $query->result() as $row )
		{
			$timezone = $row->timezone;
		}

		$datetime_objet = new DateTime('now', new DateTimeZone($timezone));
		$datetime = $datetime_objet->format('Y-m-d H:i:s');

		$sql = 'UPDATE members SET last_connection = ? WHERE id = ?';
		$this->db->query($sql, array($datetime, $this->session->member_id));

		if ( is_numeric($id) && $id > 0 )
		{
			$sql = 'SELECT members.gender, members.look_for FROM members WHERE id = ? LIMIT 1';
			$query = $this->db->query($sql, $this->session->member_id);

			foreach ( $query->result() as $row )
			{
				$gender = $row->gender;
				$look_for = $row->look_for;
			}

			$sql = 'SELECT members.id, members.picture, members.pseudonym, members.birthdate, continents.name as continent_name, countries.name as country_name, cities.name as city_name, members.description, members.non_smoker, members.religion FROM members INNER JOIN continents ON members.continent = continents.id INNER JOIN countries ON members.country = countries.id INNER JOIN cities ON members.city = cities.id WHERE members.id = ? AND members.gender = ? AND members.look_for = ? LIMIT 1';
			$query = $this->db->query($sql, array($id, $look_for, $gender));

			if ( $query->num_rows() )
				foreach( $query->result() as $row )
				{
					$send_message_data['id'] = $row->id;
					$send_message_data['picture'] = $row->picture;
					$send_message_data['pseudonym'] = $row->pseudonym;
					$send_message_data['age'] = (int) ((time() - strtotime($row->birthdate)) / (3600 * 24 * 365));
					$send_message_data['continent'] = $row->continent_name;
					$send_message_data['country'] = $row->country_name;
					$send_message_data['city'] = $row->city_name;
					$send_message_data['description'] = $row->description;
					$send_message_data['non_smoker'] = $row->non_smoker;
					$send_message_data['religion'] = $row->religion;
				}
			else redirect('/welcome/research');
			
		}
		else redirect('/welcome/research');

		$sql = 'SELECT 1 FROM messages WHERE messages.transmitter = ? AND messages.recipient = ? LIMIT 1';
		$query = $this->db->query($sql, array($this->session->member_id, $id));

		$send_message_data['message_already_sent'] = false;

		if ( $query->num_rows() )
		{
			$send_message_data['message_already_sent'] = true;
		}
		elseif( $this->input->post('send_message') )
		{
			$this->form_validation->set_rules('id', 'Recipient', 'callback_recipient_check');
			$this->form_validation->set_rules('message', 'Message', 'callback_message_check');

			if ( $this->form_validation->run() )
			{
				$sql = 'INSERT INTO messages (messages.transmitter, messages.recipient, messages.date_time, messages.text) VALUES(?, ?, ?, ?)';
				$data = array($this->session->member_id, $this->input->post('id'), $datetime_objet->format('Y-m-d H:i:s'), $this->security->xss_clean($this->input->post('message')));
				$this->db->query($sql, $data);
				if ( $this->db->affected_rows() == 1 )
					$send_message_data['message_sent'] = true;
				else
					$send_message_data['message_sent'] = false;
			}
		}

		$this->load->view('templates/header');
		$this->load->view('templates/navigation', $navigation_data);
		$this->load->view('send_message', $send_message_data);
		$this->load->view('templates/footer');
	}

	public function recipient_check($str)
	{
		$sql = 'SELECT 1 FROM members WHERE id = ? LIMIT 1';
		$query = $this->db->query($sql, $str);
		if ( $query->num_rows() )
			return true;
		else
		{
			$this->form_validation->set_message('message_recipient_check', lang('message_recipient_check'));
			return false;
		}
	}

	public function message_check($str)
	{
		$mystrlen = strlen($str);

		if ( $mystrlen > 0 && $mystrlen <= 4096 )
			return true;
		else
		{
			$this->form_validation->set_message('message_check', lang('message_check'));
			return false;
		}
	}

	public function your_conversations()
	{
		$this->load->database();
		$this->load->helper(array('cookie', 'form', 'language', 'url'));
		$this->load->library(array('form_validation', 'mylibrary', 'session'));

		if ( $this->input->post('choice_of_language') )
			$this->form_validation->set_rules('language', 'Language', 'callback_language_check');

		if ( $this->input->post('choice_of_language') && $this->form_validation->run() )
		{
			$language = $this->input->post('language');
			set_cookie('language', $language, time() + 3600 * 24 * 365, $_SERVER['HTTP_HOST'], '/', '', true, true);
		}
		else $language = $this->mylibrary->select_a_language(array('fr-FR', 'fr', 'en'), 'en');

		if ( $language == 'fr-FR' || $language == 'fr' )
		{
			$language = 'fr-FR';
			$this->lang->load('french_lang', 'french');
		}
    	else $this->lang->load('english_lang', 'english');

		$navigation_data['language'] = $language;
		$navigation_data['your_conversations'] = true;

		if ( ! $this->session->has_userdata('member_id') )
			redirect('/welcome/log_in');

		$sql = 'SELECT timezone FROM members WHERE id = ? LIMIT 1';
		$query = $this->db->query($sql, $this->session->member_id);

		foreach ( $query->result() as $row )
		{
			$timezone = $row->timezone;
		}

		$datetime_objet = new DateTime('now', new DateTimeZone($timezone));
		$datetime = $datetime_objet->format('Y-m-d H:i:s');

		$sql = 'UPDATE members SET last_connection = ? WHERE id = ?';
		$this->db->query($sql, array($datetime, $this->session->member_id));

		$sql = 'SELECT messages.id, members.pseudonym, messages.text, members2.pseudonym as pseudonym_recipient FROM messages INNER JOIN members ON messages.transmitter = members.id INNER JOIN members as members2 ON members2.id = messages.recipient WHERE messages.in_response_to = 0 AND messages.recipient = ? UNION ALL SELECT messages.id, members.pseudonym, messages.text, members2.pseudonym as pseudonym_recipient FROM messages INNER JOIN members ON messages.transmitter = members.id INNER JOIN members as members2 ON members2.id = messages.recipient WHERE messages.in_response_to = 0 AND messages.transmitter = ? AND messages.id = (SELECT DISTINCT messages.in_response_to FROM messages WHERE messages.in_response_to != 0 )';
		$query = $this->db->query($sql, array($this->session->member_id, $this->session->member_id));

		$your_conversations_data['messages'] = array();

		foreach( $query->result() as $row )
		{
			$your_conversations_data['messages'][] = $row;
		}

		$this->load->view('templates/header');
		$this->load->view('templates/navigation', $navigation_data);
		$this->load->view('your_conversations', $your_conversations_data);
		$this->load->view('templates/footer');
	}

	public function answer_message($id = null)
	{
		$this->load->database();
		$this->load->helper(array('cookie', 'form', 'language', 'url'));
		$this->load->library(array('form_validation', 'mylibrary', 'session'));

		if ( $this->input->post('choice_of_language') )
			$this->form_validation->set_rules('language', 'Language', 'callback_language_check');

		if ( $this->input->post('choice_of_language') && $this->form_validation->run() )
		{
			$language = $this->input->post('language');
			set_cookie('language', $language, time() + 3600 * 24 * 365, $_SERVER['HTTP_HOST'], '/', '', true, true);
		}
		else $language = $this->mylibrary->select_a_language(array('fr-FR', 'fr', 'en'), 'en');

		if ( $language == 'fr-FR' || $language == 'fr' )
		{
			$language = 'fr-FR';
			$this->lang->load('french_lang', 'french');
		}
    	else $this->lang->load('english_lang', 'english');

		$navigation_data['language'] = $language;

		if ( ! $this->session->has_userdata('member_id') )
			redirect('/welcome/log_in');

		$sql = 'SELECT timezone FROM members WHERE id = ? LIMIT 1';
		$query = $this->db->query($sql, $this->session->member_id);

		foreach ( $query->result() as $row )
		{
			$timezone = $row->timezone;
		}

		$datetime_objet = new DateTime('now', new DateTimeZone($timezone));
		$datetime = $datetime_objet->format('Y-m-d H:i:s');

		$sql = 'UPDATE members SET last_connection = ? WHERE id = ?';
		$this->db->query($sql, array($datetime, $this->session->member_id));

		$sql = 'SELECT * FROM messages WHERE messages.id = ? AND messages.recipient = ? UNION ALL SELECT * FROM messages WHERE messages.recipient = ? AND messages.in_response_to = ?';
		$query = $this->db->query($sql, array($id, $this->session->member_id, $this->session->member_id, $id));

		if ( $query->num_rows() == 0 )
			redirect('welcome/your_conversations');

		if( $this->input->post('send_message') )
		{
			$this->form_validation->set_rules('message', 'Message', 'callback_message_check');

			if ( $this->form_validation->run() )
			{
				$sql = 'SELECT messages.transmitter, messages.recipient FROM messages WHERE messages.id = ? LIMIT 1';
				$query = $this->db->query($sql, $id);
				foreach( $query->result() as $row )
				{
					if ( $this->session->member_id == $row->transmitter )
						$recipient = $row->recipient;
					else
						$recipient = $row->transmitter;
				}

				$sql = 'INSERT INTO messages (messages.transmitter, messages.recipient, messages.date_time, messages.text, messages.in_response_to) VALUES(?, ?, ?, ?, ?)';
				$data = array($this->session->member_id, $recipient, $datetime_objet->format('Y-m-d H:i:s'), $this->input->post('message'), $id);
				$this->db->query($sql, $data);
				if ( $this->db->affected_rows() == 1 )
					$answer_message_data['message_sent'] = true;
				else
					$answer_message_data['message_sent'] = false;
			}
		}

		$sql = 'SELECT messages.text, messages.date_time, members1.pseudonym as transmitter_pseudonym, members2.pseudonym as recipient_pseudonym FROM messages INNER JOIN members as members1 ON members1.id = messages.transmitter INNER JOIN members as members2 ON members2.id = messages.recipient WHERE messages.id = ? UNION ALL SELECT messages.text, messages.date_time, members1.pseudonym as transmitter_pseudonym, members2.pseudonym as recipient_pseudonym FROM messages INNER JOIN members as members1 ON members1.id = messages.transmitter INNER JOIN members as members2 ON members2.id = messages.recipient WHERE messages.in_response_to = ?';
		$query = $this->db->query($sql, array($id, $id));

		foreach( $query->result() as $row )
		{
			$answer_message_data['messages'][] = $row;
		}

		$answer_message_data['messages'] = array_reverse($answer_message_data['messages']);

		$sql = 'SELECT messages.transmitter, messages.recipient FROM messages WHERE messages.id = ? LIMIT 1';
		$query = $this->db->query($sql, $id);

		foreach( $query->result() as $row )
		{
			$transmitter = $row->transmitter;
			$recipient = $row->recipient;
		}

		if ( $transmitter == $this->session->member_id )
			$other_member = $recipient;
		else
			$other_member = $transmitter;

		$sql = 'SELECT members.picture, members.pseudonym, members.birthdate, members.description, members.non_smoker, members.religion, continents.name as continent_name, countries.name as country_name, cities.name as city_name FROM members INNER JOIN continents ON members.continent = continents.id INNER JOIN countries ON members.country = countries.id INNER JOIN cities ON members.city = cities.id WHERE members.id = ? LIMIT 1';
		$query = $this->db->query($sql, $other_member);

		foreach( $query->result() as $row )
		{
			$answer_message_data['other_member']['picture'] = $row->picture;
			$answer_message_data['other_member']['pseudonym'] = $row->pseudonym;
			$answer_message_data['other_member']['age'] = (int) ((time() - strtotime($row->birthdate)) / (3600 * 24 * 365));
			$answer_message_data['other_member']['continent'] = $row->continent_name;
			$answer_message_data['other_member']['country'] = $row->country_name;
			$answer_message_data['other_member']['city'] = $row->city_name;
			$answer_message_data['other_member']['description'] = $row->description;
			$answer_message_data['other_member']['non_smoker'] = $row->non_smoker;
			$answer_message_data['other_member']['religion'] = $row->religion;
		}

		$this->load->view('templates/header');
		$this->load->view('templates/navigation', $navigation_data);
		$this->load->view('answer_message', $answer_message_data);
		$this->load->view('templates/footer');
	}

	public function log_out()
	{
		$this->load->helper(array('cookie', 'form', 'language', 'url'));
		$this->load->library(array('form_validation', 'mylibrary', 'session'));

		if ( $this->input->post('choice_of_language') )
			$this->form_validation->set_rules('language', 'Language', 'callback_language_check');

		if ( $this->input->post('choice_of_language') && $this->form_validation->run() )
		{
			$language = $this->input->post('language');
			set_cookie('language', $language, time() + 3600 * 24 * 365, $_SERVER['HTTP_HOST'], '/', '', true, true);
		}
		else $language = $this->mylibrary->select_a_language(array('fr-FR', 'fr', 'en'), 'en');

		if ( $language == 'fr-FR' || $language == 'fr' )
		{
			$language = 'fr-FR';
			$this->lang->load('french_lang', 'french');
		}
    	else $this->lang->load('english_lang', 'english');

		$navigation_data['language'] = $language;

		$this->session->unset_userdata('member_id');

		$this->load->view('templates/header');
		$this->load->view('templates/navigation', $navigation_data);
		$this->load->view('log_out');
		$this->load->view('templates/footer');
	}

	public function log_in()
	{
		$this->load->database();
		$this->load->helper(array('cookie', 'form', 'language', 'url'));
		$this->load->library(array('form_validation', 'mylibrary', 'session'));

		if ( $this->input->post('choice_of_language') )
			$this->form_validation->set_rules('language', 'Language', 'callback_language_check');

		if ( $this->input->post('choice_of_language') && $this->form_validation->run() )
		{
			$language = $this->input->post('language');
			set_cookie('language', $language, time() + 3600 * 24 * 365, $_SERVER['HTTP_HOST'], '/', '', true, true);
		}
		else $language = $this->mylibrary->select_a_language(array('fr-FR', 'fr', 'en'), 'en');

		if ( $language == 'fr-FR' || $language == 'fr' )
		{
			$language = 'fr-FR';
			$this->lang->load('french_lang', 'french');
		}
    	else $this->lang->load('english_lang', 'english');

		$navigation_data['language'] = $language;
		$navigation_data['log_in'] = true;

		if ( $this->input->post('log_in') )
		{
			$this->form_validation->set_rules('email', 'Email', 'callback_log_in_email_check');
			$this->form_validation->set_rules('password', 'Password', 'callback_log_in_password_check');

			if ( $this->form_validation->run() )
			{
				redirect('welcome/your_conversations');
			}
		}

		$this->load->view('templates/header');
		$this->load->view('templates/navigation', $navigation_data);
		$this->load->view('log_in');
		$this->load->view('templates/footer');
	}

	public function log_in_email_check($str)
	{
		$this->load->helper('email');

		if ( valid_email($str) )
		{
			$sql = 'SELECT 1 FROM members WHERE email = ? LIMIT 1';
			$query = $this->db->query($sql, $str);

			if ( $query->num_rows() == 0 )
			{
				$this->form_validation->set_message('log_in_email_check', lang('log_in_email_check2'));
				return false;
			}
			else
				return true;
		}
		else
		{
			$this->form_validation->set_message('log_in_email_check', lang('log_in_email_check'));
			return false;
		}
	}

	public function log_in_password_check($str)
	{
		if ( strlen($str) > 1024 )
		{
			$this->form_validation->set_message('log_in_password_check', lang('log_in_password_len_check'));
			return false;
		}
		else
		{
			$sql = 'SELECT id, password FROM members WHERE email = ? LIMIT 1';
			$query = $this->db->query($sql, $this->input->post('email'));

			foreach ( $query->result() as $row )
			{
				$id = $row->id;
				$hash = $row->password;
			}

			if ( ! isset($hash) || ! password_verify($str, $hash) )
			{
				$this->form_validation->set_message('log_in_password_check', lang('log_in_password_check'));
				return false;
			}
			else
			{
				$sql = 'SELECT id FROM members WHERE id = ? AND register_trust = 1 LIMIT 1';
				$query = $this->db->query($sql, $id);

				if ( $query->num_rows() == 0 )
				{
					$this->form_validation->set_message('log_in_password_check', lang('log_in_password_check2'));
					return false;
				}

				foreach ( $query->result() as $row )
				{
					$this->session->member_id = $row->id;
					return true;
				}
			}
		}
	}
	
	public function cities($str = null)
	{
        $this->load->database();
        $this->load->library('session');
        if ( $this->input->is_ajax_request() && $this->session->has_userdata('country') && ! is_null($str) )
        {
            $sql = 'SELECT id, asciiname, name, alternatenames FROM cities WHERE country_id = ? AND ( asciiname LIKE ? OR name LIKE ? OR alternatenames LIKE ? ) ORDER BY asciiname';
            $str = rawurldecode($str).'%';
            $query = $this->db->query($sql, array($this->session->country, $str, $str, $str));

            foreach ( $query->result() as $row )
            {
                $result[] = array('label' => $row->asciiname.' ( '.$row->name.' ) '.$row->alternatenames, 'value' => $row->id);
            }
            
            echo json_encode($result);
        }
	}
}
