<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Mylibrary {

	/**
     * Objective: select a language.
     *
     * Use: $language = select_a_language(array('fr-FR', 'fr', 'en'), 'en');
     *
     * @param array $languages_available languages available for this website
     * Example: array('fr-FR', 'fr', 'en')
     *
     * @param string $default_language language to choose by default
     *
     * @return string the language selected by the user or browser language or the default language
     */

	public function select_a_language($languages_available, $default_language = 'en') {

		if ( get_cookie('language') )
			return get_cookie('language');
		elseif ( ! empty($_SERVER['HTTP_ACCEPT_LANGUAGE']) )
		{
			$web_browser_languages = explode(',', $_SERVER['HTTP_ACCEPT_LANGUAGE']);

			foreach ( $web_browser_languages as $value )
			{
				$web_browser_language = explode(';', $value);

				foreach ( $web_browser_language as $value )
				{
					if ( in_array($value, $languages_available) )
						return $value;
				}
			}
		}

		return $default_language;
	}

	/*
	public function force_ssl_forwarded() {
	    if (!isset($_SERVER['HTTP_X_FORWARDED_PROTO']) || $_SERVER['HTTP_X_FORWARDED_PROTO'] != 'https') {
	        $url = 'https://'. $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];
	        redirect($url, 'refresh');
	        exit();
	    }
	}

	public function force_ssl() {
	    if (!isset($_SERVER['HTTPS']) || $_SERVER['HTTPS'] != 'on') {
	        $url = 'https://'. $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];
	        redirect($url, 'refresh');
	        exit();
	    }
	}
	*/

	public function return_kilobytes ($size_str)
    {
        switch (substr ($size_str, -1))
        {
            case 'G': case 'g': return (int)$size_str * 1048576;
            case 'M': case 'm': return (int)$size_str * 1024;
            case 'K': case 'k': return (int)$size_str;
            default: return (int)((int)$size_str / 1024);
        }
    }
}

/* End of file Mylibrary.php */
