/* This file is part of Patchage.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef PATCHAGE_H
#define PATCHAGE_H

#include "config.h"
#include <string>
#include <libgnomecanvasmm.h>
#include "AlsaDriver.h"
#include "JackDriver.h"
#include "PatchagePatchBayArea.h"
#ifdef HAVE_LASH
#include "LashController.h"
#endif

using namespace std;


class Patchage
{
public:
	Patchage(int argc, char** argv);
	~Patchage();

	PatchagePatchBayArea* patch_bay()     { return m_patch_bay; }
	JackDriver*           jack_driver()   { return m_jack_driver; }
	AlsaDriver*           alsa_driver()   { return m_alsa_driver; }
	StateManager*         state_manager() { return m_state_manager; }
	Gtk::Window*          window()        { return m_main_window; }
#ifdef HAVE_LASH
	LashController*       lash_controller() { return m_lash_controller; }
#endif
	
	void attach() { m_jack_driver->attach(); m_alsa_driver->attach(); }
	void quit() { m_main_window->hide(); }

	void update_state();

	void status_message(const string& msg);
	void queue_refresh() { m_refresh = true; }
	pthread_mutex_t* refresh_mutex() { return &m_refresh_mutex; }

protected:
	void menu_file_save();
	void menu_file_quit();
	void menu_view_refresh();
	void menu_help_about();
	void close_about();
	void zoom_changed();
	bool idle_callback();

	PatchagePatchBayArea* m_patch_bay;
	JackDriver*           m_jack_driver;
	AlsaDriver*           m_alsa_driver;
	StateManager*         m_state_manager;
#ifdef HAVE_LASH
	LashController*       m_lash_controller;
#endif

	Gtk::Main* m_gtk_main;

	string          m_settings_filename;
	bool            m_refresh;
	pthread_mutex_t m_refresh_mutex;	
	
	Gtk::Window*         m_main_window;
	Gtk::Window*         m_about_window;
	Gtk::MenuItem*       m_menu_file_save;
	Gtk::MenuItem*       m_menu_file_quit;
	Gtk::MenuItem*       m_menu_view_refresh;
	Gtk::MenuItem*       m_menu_help_about;
	Gtk::ScrolledWindow* m_canvas_scrolledwindow;
	Gtk::HScale*         m_zoom_slider;
	Gtk::Button*         m_about_close_button;
	Gtk::Label*          m_status_label;
};

#endif // PATCHAGE_H
