/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef NOTEOFFEVENT_H
#define NOTEOFFEVENT_H

#include <ladspa.h>
#include "Event.h"

namespace Om {

class Patch;


/** An note off event.
 *
 * \ingroup engine
 */
class NoteOffEvent : public Event
{
public:
	NoteOffEvent(Request* request, Patch* patch, int note_num);
	NoteOffEvent(Request* request, const string& patch_path, int note_num);
	
	void execute(uint sample_offset);
	void post_process();

private:
	Patch* m_patch;
	string m_patch_path;
	int    m_note_num;
};


} // namespace Om

#endif // NOTEOFFEVENT_H
