/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "OSCController.h"
#include "PatchLibrarian.h"
#include "PatchModel.h"
#include <iostream>
#include <unistd.h>
#include "cmdline.h"  // generated by gengetopt

using std::cout;
using std::endl;

using namespace LibOmClient;

int main(int argc, char** argv)
{
	const char* engine_url  = NULL;
	int         client_port = 0;
	
	OSCController           osc_controller;
	PatchLibrarian librarian(&osc_controller);
	
	/* Parse command line options */
	gengetopt_args_info args_info;
	if (cmdline_parser (argc, argv, &args_info) != 0)
		return 1;

	if (args_info.engine_url_given) {
		engine_url = args_info.engine_url_arg;
	} else {
		cout << "[Main] No engine URL specified.  Attempting to use osc.udp://localhost:16180" << endl;
		engine_url = "osc.udp://localhost:16180";
	}	

	if (args_info.client_port_given)
		client_port = args_info.client_port_arg;
	else
		client_port = 0; // will choose a free port automatically
	
	/* Connect to engine */
	osc_controller.attach(engine_url, client_port);
	osc_controller.activate();
	osc_controller.register_client();

	int id = osc_controller.get_next_request_id();
	osc_controller.set_wait_response_id(id);
	osc_controller.load_plugins(id);
	osc_controller.wait_for_response();

	// Load patches
	for (uint i=0; i < args_info.inputs_num; ++i) {
		PatchModel* pm = new PatchModel();
		pm->path("");
		pm->parent(NULL);
		pm->poly(1);
		pm->filename(args_info.inputs[i]);
		librarian.load_patch(pm);
		delete pm;
	}
	
	return 0;
}
