/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "UnregisterClientEvent.h"
#include "Om.h"
#include "OmApp.h"
#include "OSCReceiver.h"

namespace Om {


UnregisterClientEvent::UnregisterClientEvent(Request request, const string& host, const string& port)
: SlowEvent(request),
  m_host(host),
  m_port(port),
  m_success(false)
{
}


void
UnregisterClientEvent::prepare()
{
	SlowEvent::prepare();
}


void
UnregisterClientEvent::execute(uint sample_offset)
{
	SlowEvent::execute(sample_offset);
}


void
UnregisterClientEvent::post_process()
{
	m_success = om->osc_receiver()->unregister_client(m_host, m_port);
	if (m_success)
		m_request.respond_ok();
	else
		m_request.respond_error("Unable to register client");
}


} // namespace Om

