/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef REGISTERCLIENTEVENT_H
#define REGISTERCLIENTEVENT_H

#include "SlowEvent.h"

namespace Om {


/** Registers a new client with the OSC system, so it can receive updates.
 *
 * \ingroup engine
 */
class RegisterClientEvent : public SlowEvent
{
public:
	RegisterClientEvent(Request request, const string& host, const string& port);
	
	void prepare();
	void execute(uint sample_offset);
	void post_process();

private:
	string m_host;
	string m_port;
	bool   m_success;
};


} // namespace Om

#endif // REGISTERCLIENTEVENT_H
