/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef OMAPP_H
#define OMAPP_H

#include <string>
#include "List.h"

using std::string;

namespace Om {

class JackDriver;
class AlsaDriver;
class PluginFactory;
class OSCReceiver;
class OSCSender;
class Patch;
class Maid;
class PathParser;


/** The main class for Om, the whole app lives in here
 *
 * \ingroup engine
 */
class OmApp
{
public:
	OmApp(const char* const port);
	~OmApp();
	
	int main();
	
	void set_quit_flag() { m_quit_flag = true; }
	
	void activate();
	void deactivate();
	void enable();
	void disable();

	//Patch* const patch(const string& name);
	
	void add_patch(ListNode<Patch*>* const p) { m_patches.push_back(p); }
	void remove_patch(Patch* const patch);

	List<Patch*>& patches() { return m_patches; }
	
	const sample* const zero_buffer() { return m_zero_buffer; }

	JackDriver* const    jack_driver()    { return m_jack_driver; }
	AlsaDriver* const    alsa_driver()    { return m_alsa_driver; }
	OSCReceiver* const   osc_receiver()   { return m_osc_receiver; }
	OSCSender* const     osc_sender()     { return m_osc_sender; }
	PathParser* const    path_parser()    { return m_path_parser; }
	PluginFactory* const plugin_factory() { return m_plugin_factory; }
	Maid* const          maid()           { return m_maid; }
	
private:
	JackDriver*    m_jack_driver;
	AlsaDriver*    m_alsa_driver;
	OSCReceiver*   m_osc_receiver;
	OSCSender*     m_osc_sender;
	PathParser*    m_path_parser;
	PluginFactory* m_plugin_factory;
	Maid*          m_maid;
	List<Patch*>   m_patches;

	sample*        m_zero_buffer;
	
	bool          m_quit_flag;
};


} // namespace Om

#endif // OMAPP_H
