/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef ENABLEPATCHEVENT_H
#define ENABLEPATCHEVENT_H

#include <string>
#include "SlowEvent.h"
#include "Patch.h"

using std::string;


namespace Om {


/** Enables a patch's DSP processing.
 *
 * \ingroup engine
 */
class EnablePatchEvent : public SlowEvent
{
public:
	EnablePatchEvent(Request request, const string& patch_path);
	
	void prepare();
	void execute(uint sample_offset);
	void post_process();

private:
	string       m_patch_path;
	Patch*       m_patch;
	List<Node*>* m_process_order; // Patch's new process order
};


} // namespace Om


#endif // ENABLEPATCHEVENT_H
