/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef CONTROLINPUTNODE_H
#define CONTROLINPUTNODE_H

#include <string>
#include "InputNode.h"
#include "InputPort.h"

using std::string;

namespace Om {


/** A node to represent input ports on a patch
 *
 * A patch doesn't actually contain any ports, it's port accessor methods
 * directly return ports in this node.  This is why a port on this module
 * is really two port objects - one from the internal perspective (ie
 * a port on this node in a patch), and one from the external perspective (ie
 * a port on the patch itself, being a node as well in some other patch).
 *
 * \ingroup engine
 */
class ControlInputNode : public InputNode
{
public:
	ControlInputNode(const string& path, uint poly, Patch* parent, samplerate srate, size_t buffer_size);
	virtual ~ControlInputNode();

	void activate();
	void deactivate();
	void add_to_patch(Patch* p);
	void remove_from_patch(Patch* p);
	void send_creation_messages(lo_address addr) const;
	void send_deletion_messages(lo_address addr) const;

	void run(size_t nframes) { InputNode::run(nframes); }

	InputPort* external_port() const { return m_external_port; }
};


} // namespace Om

#endif // CONTROLINPUTNODE_H
