/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License alongCont
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef CONTROLMAPMODEL_H
#define CONTROLMAPMODEL_H

#include <string>
#include <list>

using std::string; using std::list;

namespace LibOmClient {

	
/** Class to represent a preset (collection of control settings).
 *
 * \ingroup libomclient
 */
class ControlMapModel
{
public:
	ControlMapModel(const string& patch_name) : m_patch_name(patch_name)
	{}
	
	const string& name() { return m_name; }
	void          name(const string& n) { m_name = n; }

private:
	string             m_name;
	string             m_patch_name;
};


} // namespace LibOmClient

#endif // CONTROLMAPMODEL
