/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef CONNECTIONMODEL_H
#define CONNECTIONMODEL_H

#include <string>
#include <iostream>

using std::string;

namespace LibOmClient {


/** Class to represent a port->port connection in the engine
 */
class ConnectionModel
{
public:
	ConnectionModel() {}

	ConnectionModel(const string& src_port, const string& dst_port)
	{
		src_port_path(src_port);
		dst_port_path(dst_port);
	}

	
	ConnectionModel(string patch_path, string src_node, string src_port, string dst_node, string dst_port)
	: m_patch_path(patch_path),
	  m_src_node_name(src_node), m_src_port_name(src_port),
	  m_dst_node_name(dst_node), m_dst_port_name(dst_port)
	{
		m_src_port_path = patch_path +"/"+ src_node +"/"+ src_port;
		m_dst_port_path = patch_path +"/"+ dst_node +"/"+ dst_port;
	}
	
	bool operator==(const ConnectionModel& cm) {
		return (m_src_port_path == m_dst_port_path);
	}
	
	
	const string& patch_path() const    { return m_patch_path; }
	const string& src_port_path() const { return m_src_port_path; }
	const string& dst_port_path() const { return m_dst_port_path; }
	const string& src_node_name() const { return m_src_node_name; }
	const string& dst_node_name() const { return m_dst_node_name; }
	const string& src_port_name() const { return m_src_port_name; }
	const string& dst_port_name() const { return m_dst_port_name; }

	void src_port_path(const string& s)
	{
		m_src_port_path = s;
		m_src_port_name = s.substr(s.find_last_of("/")+1);
		m_src_node_name = s.substr(0, s.find_last_of("/"));
		m_patch_path = m_src_node_name.substr(0, m_src_node_name.find_last_of("/"));
		m_src_node_name = m_src_node_name.substr(m_src_node_name.find_last_of("/")+1);
	}
	
	void dst_port_path(const string& s)
	{
		m_dst_port_path = s;
		m_dst_port_name = s.substr(s.find_last_of("/")+1);
		m_dst_node_name = s.substr(0, s.find_last_of("/"));
		m_patch_path = m_dst_node_name.substr(0, m_dst_node_name.find_last_of("/"));
		m_dst_node_name = m_dst_node_name.substr(m_dst_node_name.find_last_of("/")+1);
	}
	/*uint          src_port_index() const    { return m_src_port_index; }
	void          src_port_index(int i)     { m_src_port_index = i; }
	uint          dst_port_index() const      { return m_dst_port_index; }
	void          dst_port_index(int i)       { m_dst_port_index = i; }
	*/
	
private:
	string m_src_port_path;
	string m_dst_port_path;
	string m_patch_path;
	string m_src_node_name;
	string m_src_port_name;
	string m_dst_node_name;
	string m_dst_port_name;
};


} // namespace LibOmClient

#endif // CONNECTIONMODEL_H
