/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <iostream>
#include <jack/jack.h> // FIXME: remove this
#include "ladspa.h"    // FIXME: and this
#include <signal.h>
#include "cmdline.h"
#include "Om.h"
#include "OmApp.h"
#include "OSCReceiver.h"
#include "types.h"
#include <iostream>
#include "util.h"

using std::cout; using std::endl; using std::cerr;


// Be sure glaring assumptions are correct, exit if not
// FIXME:  types throughout the engine are all screwy and intermixed, remove this
void
check_sanity()
{	
	if (sizeof(LADSPA_Data) != sizeof(jack_default_audio_sample_t)) {
		std::cerr << "sizeof(LADSPA_Data) != sizeof(jack_default_audio_sample_t), which is Not Good(TM).  Exiting." << std::endl;
		exit(1);
	}

	// FIXME: Apparently on x86-64, jack_nframes_t (which is what samplerate and samplecount are
	// typedef'd to) is 32 bits, but unsigned long (which is what LADSPA uses) is 64 bits.  There's
	// no lossiness problems (since 32bit is being assigned to 64bit), but there could be a performance
	// hit.  I don't care, since I don't have a 64 bit machine, but it's worth noting.
	
	// LADSPA functions expect unsigned long for sample rate
	/*if (sizeof(samplerate) != sizeof(unsigned long)) {
		std::cerr << "sizeof(samplerate) != sizeof(unsigned long), which is Not Good(TM).  Exiting." << std::endl;
		exit(1);
	}

	if (sizeof(samplecount) != sizeof(unsigned long)) {
		std::cerr << "sizeof(samplecount) != sizeof(unsigned long), which is Not Good(TM).  Exiting." << std::endl;
		exit(1);
	}*/
}


void
catch_int(int sig_num)
{
	signal(SIGINT, catch_int);
	signal(SIGTERM, catch_int);

	std::cout << "Om interrupted." << std::endl;
	Om::om->set_quit_flag();
}


int
main(int argc, char** argv)
{
	const char* port = NULL;

	/* Parse command line options */
	gengetopt_args_info args_info;
	if (cmdline_parser (argc, argv, &args_info) != 0)
		return 1;

	/*if (!args_info.port_given) {
		cout << "You must specify a port.  Try 'om --help'." << endl;
		return 1;
	}*/
	
	port = args_info.port_arg;
	
	/* End command line parsing */

	signal(SIGINT, catch_int);
	signal(SIGTERM, catch_int);

	check_sanity();

	// It seems like this is enough, it doesn't need to be called in the Jack thread.
	// I guess that means these flags are being restored on the context switch into
	// Om when Jack calls the process callback.
	Om::set_denormal_flags();

	Om::om = new Om::OmApp(port);

	// These need to be activated after OmApp is initialized, or incoming
	// OSC events could cause control events to exist when Om::om is still
	// NULL, causing a NULL dereference (segfault)
	Om::om->osc_receiver()->activate();

	Om::om->main();

	return 0;
}

