/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "SetMetadataEvent.h"
#include <string>
#include "Om.h"
#include "OSCSender.h"
#include "OmObject.h"

using std::string;

namespace Om {


SetMetadataEvent::SetMetadataEvent(Request request, const string& path, const string& key, const string& value)
: SlowEvent(request),
  m_path(path),
  m_key(key),
  m_value(value),
  m_object(NULL)
{
}


void
SetMetadataEvent::prepare()
{
	m_object = om->path_parser()->find_object(m_path);
	if (m_object == NULL) {
		SlowEvent::prepare();
		return;
	}

	m_object->set_metadata(m_key, m_value);

	SlowEvent::prepare();
}


void
SetMetadataEvent::execute(uint sample_offset)
{
	// Do nothing
	
	SlowEvent::execute(sample_offset);
}


void
SetMetadataEvent::post_process()
{
	if (m_object == NULL) {
		string msg = "Unable to find object ";
		msg += m_path;
		m_request.respond_error(msg);
	} else {
		m_request.respond_ok();
		om->osc_sender()->send_metadata_update(m_path, m_key, m_value);
	}
}


} // namespace Om
