/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef SENDPLUGINSEVENT_H
#define SENDPLUGINSEVENT_H

#include "SlowEvent.h"

namespace Om {


using std::string;


/** A request from a client to send notification of all objects (ie refresh).
 *
 * \ingroup engine
 */
class SendPluginsEvent : public SlowEvent
{
public:
	SendPluginsEvent(Request request);
	
	void prepare();
	void execute(uint sample_offset);
	void post_process();
};


} // namespace Om

#endif // SENDPLUGINSEVENT_H
