/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "Request.h"
#include "Om.h"
#include "OSCSender.h"

namespace Om {


void
Request::respond_ok()
{
	if (m_source != NOBODY && om != NULL && om->osc_sender() != NULL)
		om->osc_sender()->send_response_ok(m_source, m_id);
}


void
Request::respond_error(const string& msg)
{
	if (m_source != NOBODY && om != NULL && om->osc_sender() != NULL)
		om->osc_sender()->send_response_error(m_source, m_id, msg);
}


} // namespace Om
