/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef OMOBJECT_H
#define OMOBJECT_H

#include <string>
#include "MaidObject.h"
#include "MetaDataBase.h"
#include "PathParser.h"

using std::string;

namespace Om {


/** An object in the "synth space" of Om - Patch, Node, Port, etc.
 *
 * Each of these is a MaidObject and so can be deleted in a realtime safe
 * way from anywhere, and they all have a MetaDataBase
 *
 * \ingroup engine
 */
class OmObject : public MaidObject
{
public:
	OmObject(const string& path)
	: m_path(path), m_name(PathParser::name(path))
	{}
	
	virtual ~OmObject() {}

	// FIXME: needs to be virtual?
	virtual const string& path() const { return m_path; }
	virtual const string& name() const { return m_name; }

	void          set_metadata(const string& key, const string& value) { m_metadata.set(key, value); }
	const string& get_metadata(const string& key)                      { return m_metadata.get(key); }

	const map<string, string> metadata() const { return m_metadata.data(); }

protected:
	OmObject() {}
	
	string       m_path; // Full path, including name
	string       m_name; // Individual name (optimization)

private:	
	OmObject(const OmObject& copy) { throw; } // disallow copies

	MetaDataBase m_metadata;
};


} // namespace Om

#endif // OMOBJECT_H
