/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef NOTEONEVENT_H
#define NOTEONEVENT_H

#include <ladspa.h>
#include "Event.h"

namespace Om {

class Patch;


/** A note on event.
 *
 * \ingroup engine
 */
class NoteOnEvent : public Event
{
public:
	NoteOnEvent(Request request, Patch* patch, int note_num, int velocity);
	NoteOnEvent(Request request, const string& patch_path, int note_num, int velocity);
	
	void execute(uint sample_offset);

private:
	Patch* m_patch;
	string m_patch_path;
	int    m_note_num;
	int    m_velocity;
};


} // namespace Om

#endif // NOTEONEVENT_H
