/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef EVENT_H
#define EVENT_H

#include <cassert>
#include <time.h>
#include <iostream>
#include "MaidObject.h"
#include "Request.h"
class OSCSender;

namespace Om {	


/** An audio event, like control change, note on, etc.
 *
 * This is for time-critical events like note ons.  There is no non-realtime
 * pre-execute method as in slowevents, all the lookups are done in the
 * realtime execute() method.
 *
 * Rationale:  The lookups may take awhile, but the timestamp on this event
 * is critical and it must be processed by the driver ASAP (ie in this cycle)
 *
 * \ingroup engine
 */
class Event
{
public:
	virtual ~Event() { /*std::cerr << "Destroying event..." << std::endl;*/ }  

	/** Execute event, MUST be realtime safe */
	virtual void execute(uint sample_offset) { assert(m_executed == false); m_executed = true; }
	
	/** Perform any actions after execution (ie send OSC response to client)
	 * No realtime requirement */
	virtual void post_process() {}
	
	inline uint time_stamp() { return m_time_stamp; }
		
protected:
	Event(Request request);

	Event(const Event& copy) : m_request(NOBODY, 0) { throw; }  // Prevent copies

	Request m_request;
	uint    m_time_stamp;
	bool    m_executed;
};


} // namespace Om

#endif // EVENT_H
