/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef DISCONNECTIONEVENT_H
#define DISCONNECTIONEVENT_H

#include <string>
#include "SlowEvent.h"
#include "List.h"

namespace Om {

	
class Patch;
class Node;
class Connection;
class InputPort;
class OutputPort;

using std::string;


/** An event to disconnect two ports.
 *
 * \ingroup engine
 */
class DisconnectionEvent : public SlowEvent
{
public:
	DisconnectionEvent(Request request, const string& src_port_path, const string& dst_port_path);
	DisconnectionEvent(OutputPort* src_port, InputPort* dst_port);

	void prepare();
	void execute(uint sample_offset);
	void post_process();

	// Used by DisconnectNodeEvent
	const OutputPort* const src_port() { return m_src_port; }
	const InputPort* const  dst_port() { return m_dst_port; }
	
private:
	string      m_src_port_path;
	string      m_dst_port_path;
	Patch*      m_patch;
	Node*       m_src_node;
	Node*       m_dst_node;
	OutputPort* m_src_port;
	InputPort*  m_dst_port;
	
	Connection*  m_connection;
	List<Node*>* m_process_order; // Patch's new process order
	
	bool m_succeeded;
	bool m_lookup;
};


} // namespace Om


#endif // DISCONNECTIONEVENT_H
