/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "DSSIPlugin.h"
#include "AlsaDriver.h"
#include "Port.h"
#include "Patch.h"

namespace Om {


DSSIPlugin::DSSIPlugin(const string& name, uint poly, Patch* parent, DSSI_Descriptor* descriptor, samplerate srate, size_t buffer_size)
: LADSPAPlugin(name, 1, parent, descriptor->LADSPA_Plugin, srate, buffer_size),
  m_dssi_descriptor(descriptor)
{
}


void
DSSIPlugin::activate()
{
	LADSPAPlugin::activate();

	if (m_parent->alsa_port() == NULL)
		om->alsa_driver()->add_port(m_parent);
}


void
DSSIPlugin::set_ui_url(const string& url)
{
	m_ui_url = url;
	m_ui_addr = lo_address_new_from_url(url.c_str());
	char* base_path = lo_url_get_path(url.c_str());
	m_ui_base_path = base_path;
	free(base_path);
}


void
DSSIPlugin::send_update()
{
	string path = m_ui_base_path + "/show";
	lo_send(m_ui_addr, path.c_str(), NULL);
}


void
DSSIPlugin::set_control(int port_num, sample val)
{
	*(m_ports.at(port_num)->buffer(0)) = val;
}


void
DSSIPlugin::configure(const string& key, const string& val)
{
	m_dssi_descriptor->configure(m_instances[0], key.c_str(), val.c_str());
}


void
DSSIPlugin::program(int bank, int program)
{
	if (m_dssi_descriptor->select_program)
		m_dssi_descriptor->select_program(m_instances[0], bank, program);
}


void
DSSIPlugin::run(size_t nframes)
{
	NodeBase::run(nframes);

	if (m_dssi_descriptor->run_synth) {
		m_dssi_descriptor->run_synth(m_instances[0], nframes,
			m_parent->dssi_events_array(), m_parent->dssi_events_size());
	} else if (m_dssi_descriptor->run_multiple_synths) {  // I hate this stupid function
		snd_seq_event_t* events[1] = { m_parent->dssi_events_array() };
		long unsigned events_sizes[1] =  { m_parent->dssi_events_size() };
		m_dssi_descriptor->run_multiple_synths(1, m_instances, nframes,
			events, events_sizes);
	} else {
		LADSPAPlugin::run(nframes);
	}
}


} // namespace Om
