/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <iostream>
#include <unistd.h>
#include <libgnomecanvasmm.h>
#include <string>
#include "OmGtk.h"
#include "OmGtkStateManager.h"
#include "Controller.h"
#include "OmGtkApp.h"
#include "cmdline.h"

using std::string; using std::cout; using std::cerr; using std::endl;
using namespace OmGtk;

bool cleanup();

int main(int argc, char *argv[])
{
	OmGtk::controller = new Controller();

	bool using_default = false;
	
	const char* engine_host = NULL;
	int         engine_port = 0;
	const char* engine_url  = NULL;
	const char* client_host = NULL;
	int         client_port = 0;
	
	/* Parse command line options */
	gengetopt_args_info args_info;
	if (cmdline_parser (argc, argv, &args_info) != 0)
		return 1;

	if ( /*! args_info.launch_engine_given &&*/ ! (args_info.port_given || args_info.url_given)) {
		//cout << "You must either use -l to launch an engine, or specify which engine to connect to." << endl;
		cout << "No engine port or URL specified.  Attempting to use localhost:16180." << endl;
		using_default = true;
	}	

	/*if (args_info.launch_engine_given) {
		if (args_info.port_given)
			port = args_info.port_arg;
		else
			port = "16180";
		string cmdline = "../../../engine/om -p ";
		cmdline.append(port).append(" &");
		cout << "Executing \'" << cmdline << "... ";
		system(cmdline.c_str());
		cout << "done." << endl;
		cout << "Attempting to contact Om engine at " << host << ":" << port << "..." << endl;
		// FIXME
		sleep(1);
		controller->attach("localhost", port);
	} else {*/
		// Attempt to connect if the user specified a server
		if (args_info.client_host_given) {
			client_host = args_info.client_host_arg;
		}
		if (args_info.client_port_given) {
			client_port = args_info.client_port_arg;
		}
		
		if (using_default) {
			engine_host = "localhost";
			engine_port = 16180;
			controller->attach(engine_host, engine_port, client_port);
		} else if (args_info.port_given) {
			if (args_info.host_given)
				engine_host = args_info.host_arg;
			else
				engine_host = "localhost";
			engine_port = args_info.port_arg;
			cout << "Attempting to contact Om engine at " << engine_host
				<< ":" << engine_port << "..." << endl;
			controller->attach(engine_host, engine_port, client_port);
		} else if (args_info.url_given) {
			engine_url = args_info.url_arg;
			cout << "Attempting to contact Om engine at " << engine_url << "..." << endl;
			controller->attach_url(engine_url, client_port);
		} else {
			cerr << "Invalid command line arguments, aborting." << endl;
			exit(1);
		}

		if (args_info.client_host_given) {
			if (client_port != 0)
				cout << "(Registering as " << client_host << ":" << client_port << ")" << endl;
			else
				cout << "(Registering as " << client_host << ")" << endl;
			controller->register_client(client_host, client_port);
		} else {
			controller->register_client();
		}
	//}

	Gnome::Canvas::init();
	Gtk::Main gtk_main(argc, argv);

	OmGtk::state_manager = new OmGtk::OmGtkStateManager();
	controller->launch_thread();
	app = new OmGtkApp();
	
	gtk_main.signal_quit().connect(sigc::ptr_fun(cleanup));
			
	gtk_main.run(*app->window());

	return 0;
}


bool
cleanup()
{
	delete app;
	delete controller;
	delete state_manager;

	return false;
}
