/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "SubpatchModule.h"
#include "PluginModule.h"
#include "NodeControlWindow.h"
#include "PatchModel.h"
#include "PatchWindow.h"
#include "OmGtk.h"
#include "OmGtkApp.h"
#include "OmPort.h"
#include "OmPatchBayArea.h"

namespace OmGtk {


SubpatchModule::SubpatchModule(OmPatchBayArea* patch_bay,
                               PatchWindow* pw, PatchController* patch_controller)
: PluginModule(patch_bay, pw->patch_controller()->model(), patch_controller),
  m_patch_model(pw->patch_controller()->model()),
  m_patch_window(pw),
  m_dialog(NULL)
{
	Gtk::Menu::MenuList& items = m_menu.items();
	items.push_back(Gtk::Menu_Helpers::MenuElem("Show patch window",
		sigc::mem_fun(this, &SubpatchModule::show_patch_window)));
}


void
SubpatchModule::metadata_update(const MetadataModel* const mm)
{
	if (mm->key() == "filename") {
		m_patch_model->filename(mm->value());
	} else {
		PluginModule::metadata_update(mm);
	}
}


void
SubpatchModule::show_patch_window()
{
	PatchWindow* const pw = m_patch_window;
	if (pw != NULL) {
		pw->show();
		pw->raise();
		pw->show();
	} else {
		std::cerr << "** Unable to find PatchWindow for subpatch!" << std::endl;
	}
}


void
SubpatchModule::show_dialog()
{
	m_patch_window->show_control_window();
}


void
SubpatchModule::menu_remove()
{
	controller->destroy_patch(m_patch_model->path());
}


} // namespace OmGtk
