/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef OMPATCHBAYAREA_H
#define OMPATCHBAYAREA_H

#include <string>
#include "canvas/PatchBayArea.h"

using std::string;
using namespace PatchBay;

using PatchBay::Port;

namespace OmGtk {
	

class OmPatchBayArea : public PatchBay::PatchBayArea
{
public:
	OmPatchBayArea(const string& patch_name, int width, int height);
	
	void connect(const Port* const port1, const Port* const port2);
	void disconnect(const Port* const port1, const Port* const port2);
	
	void status_message(const string& msg);

private:
	string m_patch_path;
	string m_patch_name;
};


} // namespace OmGtk

#endif // OMPATCHBAYAREA_H
