/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "OmPatchBayArea.h"
#include "canvas/PatchBayArea.h"
#include "OmGtk.h"
#include "OmGtkApp.h"
#include "Controller.h"

namespace OmGtk {


OmPatchBayArea::OmPatchBayArea(const string& patch_path, int width, int height)
: PatchBayArea(width, height),
  m_patch_path(patch_path)
{
	m_patch_name = patch_path.substr(patch_path.find_last_of("/")+1);
}


void
OmPatchBayArea::connect(const Port* const port1, const Port* const port2)
{
	controller->connect(m_patch_path +"/"+ port1->module()->name() +"/"+ port1->name(),
	                    m_patch_path +"/"+ port2->module()->name() +"/"+ port2->name());
}

void
OmPatchBayArea::disconnect(const Port* const port1, const Port* const port2)
{
	controller->disconnect(m_patch_path +"/"+ port1->module()->name() +"/"+ port1->name(),
	                    m_patch_path +"/"+ port2->module()->name() +"/"+ port2->name());
}


void
OmPatchBayArea::status_message(const string& msg)
{
	app->status_message(msg);
}


} // namespace OmGtk
