/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef NODECONTROLWINDOW_H
#define NODECONTROLWINDOW_H

#include <vector>
#include <string>
#include <gtkmm.h>
#include <libglademm/xml.h>
#include <libglademm.h>
#include <sigc++/sigc++.h>
#include "PortModel.h"
using std::string; using std::vector;


namespace LibOmClient { class NodeModel; }
using namespace LibOmClient;

namespace OmGtk {
	
class PatchController;
class ControlGroup;


/** Window with controls (sliders) for all control-rate ports on a Node.
 *
 * \ingroup OmGtk
 */
class NodeControlWindow : public Gtk::Window
{
public:
	NodeControlWindow(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& glade_xml);
	virtual ~NodeControlWindow();
	
	void init(PatchController* patch_controller, NodeModel* node_model);

	void add_port(PortModel* pm, bool resize=true);
	void resize();

	// callback for ControlGroup
	virtual void value_changed(float val, const string& port_path);

	void set_control(const string& port_path, float value);
	void set_range_min(const string& port_path, float value);
	void set_range_max(const string& port_path, float value);

private:
	PatchController* m_patch_controller;
	NodeModel*       m_node_model;

	void all_voices_selected();
	void specific_voice_selected();
	void voice_selected();

	vector<ControlGroup*> m_controls;
	Gtk::VBox*            m_control_box;
	Gtk::ScrolledWindow*  m_scrolled_window;
	Gtk::RadioButton*     m_all_voices_radio;
	Gtk::RadioButton*     m_specific_voice_radio;
	Gtk::SpinButton*      m_voice_spinbutton;
	bool                  m_callback_enabled;
};


} // namespace OmGtk

#endif // NODECONTROLWINDOW_H
