/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef LOADPATCHWINDOW_H
#define LOADPATCHWINDOW_H

#include "PluginInfo.h"
#include <libglademm/xml.h>
#include <gtkmm.h>

namespace OmGtk {
	
class PatchController;


/** 'Add Patch' window.
 *
 * Loaded by glade as a derived object.  This is actually used for the top
 * level "Load Patch" window as well, the name needs to be changed.
 *
 * \ingroup OmGtk
 */
class LoadPatchWindow : public Gtk::FileChooserDialog
{
public:
	LoadPatchWindow(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& xml);

	void patch_controller(PatchController* pc);

private:
	void name_from_file_selected();
	void name_from_user_selected();
	void poly_from_file_selected();
	void poly_from_user_selected();
	void ok_clicked();
	void cancel_clicked();

	PatchController* m_patch_controller;
	
	Gtk::RadioButton* m_name_from_file_radio;
	Gtk::RadioButton* m_name_from_user_radio;
	Gtk::Entry*       m_name_entry;
	Gtk::RadioButton* m_poly_from_file_radio;
	Gtk::RadioButton* m_poly_from_user_radio;
	Gtk::SpinButton*  m_poly_spinbutton;
	Gtk::Button*      m_ok_button;
	Gtk::Button*      m_cancel_button;
};
 

} // namespace OmGtk

#endif // LOADPATCHWINDOW_H
