/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef CONTROLGROUPS_H
#define CONTROLGROUPS_H


#include <gtkmm.h>
#include <libglademm/xml.h>
#include <libglademm.h>
#include <sigc++/sigc++.h>

namespace LibOmClient { class PortModel; }
using namespace LibOmClient;

namespace OmGtk {
	

/** A group of controls in a NodeControlWindow.
 *
 * \ingroup OmGtk
 */
class ControlGroup : public Gtk::VBox
{
public:
	ControlGroup(PortModel* pm)
	: m_port_model(pm) {}
	
	virtual void set_value(float val) = 0;
	sigc::signal<void, float> signal_value_changed() { return m_signal_value_changed; }
	
	const PortModel* port_model() { return m_port_model; }

	virtual void set_min(float val) {}
	virtual void set_max(float val) {}

protected:
	PortModel*                m_port_model;
	sigc::signal<void, float> m_signal_value_changed;
};


/** A slider for a continuous control.
 *
 * \ingroup OmGtk
 */
class SliderControlGroup : public ControlGroup
{
public:
	SliderControlGroup(PortModel* pm);
	
	void set_value(float val);
	void set_min(float val);
	void set_max(float val);

private:
	void update_range();
	void update_value_from_slider();
	void update_value_from_spinner();

	float m_last_signalled_val;
	bool m_enable_signal;
	
	Gtk::HBox       m_slider_box;
	Gtk::Label      m_name_label;
	Gtk::Label      m_range_label;
	Gtk::HScale     m_slider;
	Gtk::SpinButton m_value_spinner;
	Gtk::SpinButton m_min_spinner;
	Gtk::SpinButton m_max_spinner;
};


/** A spinbutton for integer controls.
 * 
 * \ingroup OmGtk
 */
class IntegerControlGroup : public ControlGroup
{
public:
	IntegerControlGroup(PortModel* pm);
	
	void set_value(float val);

private:
	void update_value();
	
	bool            m_enable_signal;
	Gtk::Alignment  m_alignment;
	Gtk::Label      m_name_label;
	Gtk::SpinButton m_spinner;
};


/** A radio button for toggle controls.
 * 
 * \ingroup OmGtk
 */
class ToggleControlGroup : public ControlGroup
{
public:
	ToggleControlGroup(PortModel* pm);
	
	void set_value(float val);

private:
	void update_value();
	
	bool             m_enable_signal;
	Gtk::Alignment   m_alignment;
	Gtk::Label       m_name_label;
	Gtk::CheckButton m_checkbutton;
};


} // namespace OmGtk

#endif // CONTROLGROUPS_H
