/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "Comm.h"
#include "PatchLibrarian.h"
#include "DemolitionClientHooks.h"
#include <iostream>
#include <unistd.h>
#include <stdlib.h>
#include "cmdline.h"  // generated by gengetopt

using std::cout;
using std::endl;

using namespace LibOmClient;

void do_something();

void create_patch(); 
void destroy_patch(); 
void add_node(); 
void remove_node(); 
void connect(); 
void disconnect(); 
void disconnect_all(); 
void set_control(); 
void set_control_slow(); 


int
main(int argc, char** argv)
{
	const char* host = NULL;
	int port = 0;
	const char* url  = NULL;

	DemolitionModel*       model = new DemolitionModel();
	DemolitionClientHooks* client_hooks = new DemolitionClientHooks(model);
	Comm                   comm(client_hooks);
	PatchLibrarian         librarian(&comm);
	
	/* Parse command line options */
	gengetopt_args_info args_info;
	if (cmdline_parser (argc, argv, &args_info) != 0)
		return 1;

	if (args_info.host_given && args_info.port_given) {
		host = args_info.host_arg;
		port = args_info.port_arg;
		cout << "Attempting to contact Om engine at " << host << ":" << port << "..." << endl;
		comm.attach(host, port);
	} else if (args_info.url_given) {
		url = args_info.url_arg;
		cout << "Attempting to contact Om engine at " << url << "..." << endl;
		comm.attach_url(url);
	} else {
		host = "localhost";
		port = 16180;
		cout << "No engine address given, assuming localhost:16180" << endl;
		comm.attach(host, port);
	}

	int id = comm.get_next_request_id();
	comm.set_wait_response_id(id);
	comm.ping(id);
	comm.wait_for_response();
	id = comm.get_next_request_id();
	comm.set_wait_response_id(id);
	comm.activate();
	comm.enable();
	comm.load_plugins(id);
	comm.wait_for_response();

	while (true) {
		do_something();
		usleep(1000);
	}
	// Load patches
	for (uint i=0; i < args_info.inputs_num; ++i) {
		PatchModel* pm = new PatchModel();
		pm->path("");
		pm->parent(NULL);
		pm->poly(1);
		pm->filename(args_info.inputs[i]);
		librarian.load_patch(pm);
		delete pm;
	}
	
	return 0;
}


/** Does some random action
 */
void do_something()
{
	int action = rand() % 9;

	switch(action) {
	case 0:
		create_patch(); break;
	case 1:
		destroy_patch(); break;
	case 2:
		add_node(); break;
	case 3:
		remove_node(); break;
	case 4:
		connect(); break;
	case 5:
		disconnect(); break;
	case 6:
		disconnect_all(); break;
	case 7:
		set_control(); break;
	case 8:
		set_control_slow(); break;
	default:
		break;
	}
}



void create_patch()
{
}

 
void destroy_patch()
{
}

 
void add_node()
{
}

 
void remove_node()
{
}

 
void connect()
{
}

 
void disconnect()
{
}

 
void disconnect_all()
{
}

 
void set_control()
{
}

 
void set_control_slow()
{
}

 
