/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "DemolitionModel.h"
#include <stdlib.h>
#include <iostream>
using std::cout; using std::cerr; using std::endl;


DemolitionModel::~DemolitionModel()
{
	for (vector<PluginInfo*>::iterator i = m_plugins.begin(); i != m_plugins.end(); ++i)
		delete *i;

	for (vector<PatchModel*>::iterator i = m_patches.begin(); i != m_patches.end(); ++i)
		delete *i;
}


PatchModel*
DemolitionModel::random_patch()
{
	if (m_patches.size() == 0)
		return NULL;
	else
		return m_patches.at(rand() % m_patches.size());
}


NodeModel*
DemolitionModel::random_node()
{
	PatchModel* pm = random_patch();

	if (pm == NULL) {
		return NULL;
	} else {
		int size = pm->nodes().size();
		int index = rand() % size;
		NodeModelMap::const_iterator i = pm->nodes().begin();
		for (int j=0; j < index; ++j) {
			++i;
			if (i == pm->nodes().end())
				throw;
		}
		return (*i).second;
	}
}
			

void
DemolitionModel::remove_patch(const string& path)
{
	for (vector<PatchModel*>::iterator i = m_patches.begin(); i != m_patches.end(); ++i) {
		if ((*i)->path() == path) {
			delete (*i);
			m_patches.erase(i);
			return;
		}
	}
	cerr << "Got patch removal for non existant patch!  Aborting.";
	throw;
}


void
DemolitionModel::add_node(NodeModel* nm)
{
}


void
DemolitionModel::remove_node(const string& path)
{
}


void
DemolitionModel::add_port(PortModel* pm)
{
}


void
DemolitionModel::remove_port(const string& path)
{
}


void
DemolitionModel::add_connection(ConnectionModel* cm)
{
}


void
DemolitionModel::remove_connection(const string& src_port_path, const string& dst_port_path)
{
}

