/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef PATCHMODEL_H
#define PATCHMODEL_H

#include <list>
#include <string>
#include <map>
#include "NodeModel.h"

using std::list; using std::string; using std::map;

namespace LibOmClient {

class ConnectionModel;
	

/** Client's model of a patch.
 *
 * \ingroup libomclient
 */
class PatchModel : public NodeModel
{
public:
	PatchModel() : NodeModel() {}

	PatchModel(const string& patch_path, uint poly)
	: NodeModel(patch_path, poly)
	{}
	
	const list<ConnectionModel*>&   connections() const   { return m_connections; }
	
	PatchModel* parent()               { return m_parent; }
	void        parent(PatchModel* pm) { m_parent = pm; }
	NodeModel*  get_node(const string& node_name);
	
	const NodeModelMap& nodes() const { return m_nodes; }
	void                add_node(NodeModel* nm)  { m_nodes[nm->name()] = nm; }
	void                remove_node(const string& name);
	PatchModel*         get_subpatch(const string& name);
	ConnectionModel*    get_connection(const string& src_port_path, const string& dst_port_path);
	void                add_connection(ConnectionModel* cm);
	void                remove_connection(const string& src_port_path, const string& dst_port_path);
	const string&       filename()                { return m_filename; }
	void                filename(const string& f) { m_filename = f; }
	
	bool polyphonic() const { return (m_parent == NULL) ? (m_poly > 1)
		: (m_poly == m_parent->poly() && m_poly > 1); }

	bool operator==(const PatchModel& pm) { return m_path == pm.m_path; }

private:
	NodeModelMap             m_nodes;
	list<ConnectionModel*>   m_connections;
	string                   m_filename;
};

typedef map<string, PatchModel*> PatchModelMap;


} // namespace LibOmClient

#endif // PATCHMODEL_H
