#
# Copyright (C) 2003,2004,2006,2008 Dmitry Fedorov <dm.fedorov@gmail.com>
#
# This file is part of Offmirror.
#
# Offmirror is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Offmirror is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Offmirror; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02110-1301  USA

package OffMirror::User;

require 5.004;
use strict;
local $^W=1; # use warnings only since 5.006
use integer;

use OffMirror::Cache;


BEGIN
{
    use Exporter;
    use vars qw($VERSION @ISA @EXPORT);

    $VERSION = do { my @r = (q$Revision: 1.19 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r };
    @ISA = ('Exporter');
    @EXPORT = qw( &get_usr_name &get_usr_id &warn_no_user_once
		  &get_grp_name &get_grp_id &warn_no_group_once );
}


#+ get_usr_name()
my $_get_usr_name = sub ($)
{
    my $uid = $_[0];
    my $name = getpwuid($uid);
    $name = $uid unless defined $name;
    return $name;
};

my $uid_name_cache = OffMirror::Cache::new(\&$_get_usr_name);

# name = get_usr_name(uid)
# on failrure returns uid number from arg
sub get_usr_name($)
{
    return $uid_name_cache->get_value($_[0]);
}
#- get_usr_name()


#+ get_grp_name()
my $_get_grp_name = sub ($)
{
    my $gid = $_[0];
    my $name = getgrgid($gid);
    $name = $gid unless defined $name;
    return $name;
};

my $gid_name_cache = OffMirror::Cache::new(\&$_get_grp_name);

# name = get_grp_name(gid)
# on failrure returns gid number from arg
sub get_grp_name($)
{
    return $gid_name_cache->get_value($_[0]);
}
#- get_grp_name()


#+ get_usr_id()
my $_get_usr_id = sub ($)
{
    my $uid = getpwnam($_[0]);
    $uid = -1 unless defined $uid;
    return $uid;
};

my $name_uid_cache = OffMirror::Cache::new(\&$_get_usr_id);

# uid = get_usr_id(name)
# on failrure returns -1
sub get_usr_id($)
{
    return $name_uid_cache->get_value($_[0]);
}
#- get_usr_id()


#+ get_grp_id()
my $_get_grp_id = sub ($)
{
    my $gid = getgrnam($_[0]);
    $gid = -1 unless defined $gid;
    return $gid;
};

my $name_gid_cache = OffMirror::Cache::new(\&$_get_grp_id);

# gid = get_grp_id(name)
# on failrure returns -1
sub get_grp_id($)
{
    return $name_uid_cache->get_value($_[0]);
}
#- get_grp_id()


#+ one-time no user warning
my $_no_user = sub ($)
{
    my $user = $_[0];
    print STDERR "No such user: $user\n";
    return 1;
};

my $no_user = OffMirror::Cache::new(\&$_no_user);

sub warn_no_user_once($)
{
    $no_user->get_value($_[0]);
}
#- one-time no user warning


#+ one-time no group warning
my $_no_group = sub ($)
{
    my $group = $_[0];
    print STDERR "No such group: $group\n";
    return 1;
};

my $no_group = OffMirror::Cache::new(\&$_no_group);

sub warn_no_group_once($)
{
    $no_group->get_value($_[0]);
}
#- one-time no group warning



1;
