//     Copyright (C) 2008 Francisco Jerez
//     This file is part of offlinefs.

//     offlinefs is free software: you can redistribute it and/or modify
//     it under the terms of the GNU General Public License as published by
//     the Free Software Foundation, either version 3 of the License, or
//     (at your option) any later version.

//     offlinefs is distributed in the hope that it will be useful,
//     but WITHOUT ANY WARRANTY; without even the implied warranty of
//     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//     GNU General Public License for more details.

//     You should have received a copy of the GNU General Public License
//     along with offlinefs.  If not, see <http://www.gnu.org/licenses/>.

#ifndef SOURCES_SOURCE_HXX
#define SOURCES_SOURCE_HXX

#include <common.hxx>
#include <fsnodes.hxx>

// Class that would implement every possible operation over an open file
class Source{
   protected:
      FsDb& dbs;
      uint64_t fileid;
      off_t size;
      int mode;
   public:
      Source(FsTxn& txns,uint64_t fileid,int mode);
      virtual ~Source() {}
      uint64_t getfileid() {return fileid;}

      // Analogous to the standard unix calls
      virtual int read(char* buf, size_t nbyte, off_t offset)=0;
      virtual int write(const char* buf, size_t nbyte, off_t offset)=0;
      virtual int flush()=0;
      virtual int fsync(int datasync)=0;
};

#endif
