# Copyright (C) 2005 Jorge Arroyo <trozo@makasoft.net>
# Written using (lots of) code from OddMuse, Copyright (C) 2004  Alex Schroeder <alex@emacswiki.org>
# and partial-journal.pl, Copyright (C) 2004  Brock Wilcox <awwaiid@thelackthereof.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the
#    Free Software Foundation, Inc.
#    59 Temple Place, Suite 330
#    Boston, MA 02111-1307 USA

$ModulesDescription .= '<p>$Id: xml-journal.pl,v 0.4 2005/02/07 19:55:38 as Exp $</p>';

use vars qw($EndOfJournal $enclosure);

$EndOfJournal = 0;
$enclosure = '';


$Action{xmljournal} = \&DoXmlJournal;

push(@MyRules, \&EnclosureRule);

sub EnclosureRule {
  if (m/\G(\[enclosure:$FullUrlPattern\s+([^\]]+?)\s+([^\]]+?)])/cog) {
  $enclosure = "\<enclosure url =\"" . $2 . "\" length=\"" . $3 . "\" type=\"" . $4 . "\" \/\>";
    return ' ';
  }
  return undef;
}


sub XmlBrowsePage {
  my ($id, $raw, $comment, $status) = @_;
  
  OpenPage($id);
  my ($text, $revision) = GetTextRevision(GetParam('revision', ''));
  # handle a single-level redirect
  
  # shortcut if we only need the raw text: no caching, no diffs, no html.
  
    print GetHttpHeader('application/rss+xml');
    #print GetHttpHeader('text/html');
    print "\<\?xml version=\"1.0\"\?\>\n\<rss version=\"2.0\"\>\n\<channel\>\n\<title\>";
	my $title = $id;
    $title =~ s/_/ /g;
    $title = $SiteName . " - " . $title;
	print $title;
	print "\<\/title>";
  	
  	print "\<link\>" . XmlGetPageLink($id) . "\<\/link\>\n";
  	
  	#print "\<description\>" . $title . "\<\/description\>\n";
  	print "\<description\>\<\!\[CDATA\[\n";
    my $savecache = 0; # new page not cached
    PrintWikiToHTML($text, $savecache, $revision); # unlocked, with anchors, unlocked

	print "\<\/channel\>\n\<\/rss\>\n"; 
}

sub XmlPrintJournal {
  return if $CollectingJournal; # avoid infinite loops
  local $CollectingJournal = 1;
  my ($num, $regexp, $mode) = @_;
  $regexp = '^\d\d\d\d-\d\d-\d\d' unless $regexp;
  $num = 10 unless $num;
  my @pages = (grep(/$regexp/, AllPagesList()));
  if (defined &JournalSort) {
    @pages = sort JournalSort @pages;
  } else {
    @pages = sort {$b cmp $a} @pages;
  }
  if ($mode eq 'reverse') {
    @pages = reverse @pages;
  }
  @pages = @pages[0 .. $num - 1] if $#pages >= $num;
  if (@pages) {
    # Now save information required for saving the cache of the current page.
    local %Page;
    local $OpenPageName='';
    print "\]\]\>\<\/description\>";
    XmlPrintAllPages(1, 1, @pages);
    
  }
}


sub XmlPrintAllPages {
  my $links = shift;
  my $comments = shift;
  
  for my $id (@_) {
    OpenPage($id);
    
    my $texto = $Page{'text'};
    my $longer = 0;
    if ($texto =~ /((.*\n)*.*)\n\s*--\s*cut\s*--\s*/) {
      $texto = $1;
     
      
    }
    $enclosure = '';
    
    my $title = $id;
    $title =~ s/_/ /g;
    print "\<item\>\n\<title\>".$title . "\<\/title\>\n";
    print "\<link\>" . XmlGetPageLink($id) . "\<\/link\>\n";
    print "\<description\>\<\!\[CDATA\[\n";
    #PrintPageHtml();
    #print $texto;
    #XmlPrintWikiToHTML($texto);
    #XmlPrintWikiToHTML($texto, 1);
    PrintWikiToHTML($texto);
    print "\]\]\>\<\/description\>";
    if ($enclosure) {print $enclosure."\n";}
    $enclosure = '';
    print "\<\/item\>\n";

	#if ($enclosure   ) {
	
	#}
     
    
      }
   $EndOfJournal = 1;
}

sub XmlGetPageLink { # use if you want to force a link to local pages, whether it exists or not
  my ($id, $name) = @_;
  $id = FreeToNormal($id);
  $name = $id unless $name;
  $name =~ s/_/ /g;
  #return UrlEncode($id);
  return XmlScriptLink(UrlEncode($id), $name, 'local');
}



sub XmlScriptLink {
  my ($action, $text, $class, $name, $title, $accesskey) = @_;
  my %params;
  if ($UsePathInfo and !$Monolithic and $action !~ /=/) {
    $params{-href} = $ScriptName . '/' . $action;
  } elsif ($Monolithic) {
    $params{-href} = '#' . $action;
  } else {
    $params{-href} = $ScriptName . '?' . $action;
  }
  $params{'-class'} = $class  if $class;
  $params{'-name'} = UrlEncode($name)  if $name;
  $params{'-title'} = $title  if $title;
  $params{'-accesskey'} = $accesskey  if $accesskey;
  #return $q->a(\%params, $text);
  return $params{-href};
}





sub DoXmlJournal {

*OldPrintJournal = *PrintJournal;
*PrintJournal = *XmlPrintJournal;


my $id = FreeToNormal(shift);
  my ($class, $resolved, $title, $exists) = ResolveId($id);
    XmlBrowsePage($resolved, 0);
  

*PrintJournal = *OldPrintJournal;


}
