# Copyright (C) 2004  Alex Schroeder <alex@emacswiki.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the
#    Free Software Foundation, Inc.
#    59 Temple Place, Suite 330
#    Boston, MA 02111-1307 USA

$ModulesDescription .= '<p>$Id: toc.pl,v 1.21 2004/12/05 04:03:32 as Exp $</p>';

push(@MyRules, \&TocRule);

# This must come *before* the usemod.pl rules and adds support for
# portrait-support.pl
$RuleOrder{ \&TocRule } = 90;

my $TocCounter = 0;

sub TocRule {

    # copied from usemod.pl
    # headings using = (with lookahead)
    if (   $bol
        && $UseModMarkupInTitles
        && m/\G(\s*\n)*(\=+)[ \t]*(?=[^=\n]+=)/cg) {
        my $depth = length($2);
        $depth = 6 if $depth > 6;
	my $html = CloseHtmlEnvironments() . ($PortraitSupportColorDiv ? '</div>' : '')
	  . AddHtmlEnvironment('h' . $depth) . $q->a({-id=>'toc' . $TocCounter++})
          . AddHtmlEnvironment('p');
	$PortraitSupportColorDiv = 0; # after the HTML has been determined.
	$PortraitSupportColor = 0;
        return $html;
    } elsif (   $UseModMarkupInTitles
	     && m/\G[ \t]*=+\n?/cg
	     && (   InElement('h1')
		 || InElement('h2')
		 || InElement('h3')
		 || InElement('h4')
		 || InElement('h5')
		 || InElement('h6'))) {
        return CloseHtmlEnvironments() . AddHtmlEnvironment('p');
    } elsif ($bol
        && !$UseModMarkupInTitles
        && m/\G(\s*\n)*(\=+)[ \t]*(.+?)[ \t]*(=+)[ \t]*\n?/cg) {
        my $depth = length($2);
        $depth = 6 if $depth > 6;
	my $text = $3;
	my $html = CloseHtmlEnvironments() . ($PortraitSupportColorDiv ? '</div>' : '') . "<h$depth>"
	  . $q->a({-id=>'toc' . $TocCounter++}, $text) . "</h$depth>" . AddHtmlEnvironment('p');
	$PortraitSupportColorDiv = 0; # after the HTML has been determined.
	$PortraitSupportColor = 0;
        return $html;
    }
    return undef;
}

*OldTocGetHeader = *GetHeader;
*GetHeader       = *NewTocGetHeader;

sub NewTocGetHeader {
    my ($id) = @_;
    my $result = OldTocGetHeader(@_);

    # append TOC to header
    $result .= TocHeadings($id) if $id;
    return $result;
}

sub TocHeadings {
    my $id = shift;
    $page = GetPageContent($id);

    # ignore all the stuff that gets processed anyway
    foreach my $tag ('nowiki', 'pre', 'code') {
        $page =~ s|<$tag>(.*\n)*?</$tag>||gi;
    }
    my $Headings           = "<h2>" . T('Contents') . "</h2>";
    my $HeadingsLevel      = undef;
    my $HeadingsLevelStart = undef;
    my $count              = 0;

    # try to determine what will end up as a header
    foreach $line (grep(/^\=+.*\=+[ \t]*$/, split(/\n/, $page))) {
        next unless $line =~ /^(\=+)[ \t]*(.*?)[ \t]*\=+[ \t]*$/;
        my $depth = length($1);
        my $text  = $2;
        next unless $text;
        my $link = "toc$count";
        $text = QuoteHtml($text);
        if (not defined $HeadingsLevelStart) {

    # $HeadingsLevel is set to $depth - 1 so that we get an opening of the list.
    # We need $HeadingsLevelStart to close all open tags at the end.
            $HeadingsLevel      = $depth - 1;
            $HeadingsLevelStart = $depth - 1;
        }
        $count++;

        # if the first subheading is has depth 2, then
        # $HeadingsLevelStart is 1, and later subheadings may not be
        # at level 1 or below.
        $depth = $HeadingsLevelStart + 1 if $depth <= $HeadingsLevelStart;
        $depth = 6 if $depth > 6;

        # the order of the three expressions is important!
        while ($HeadingsLevel > $depth) {
            $Headings .= '</li></ol>';
            $HeadingsLevel--;
        }
        if ($HeadingsLevel == $depth) {
            $Headings .= '</li><li>';
        }
        while ($HeadingsLevel < $depth) {
            $Headings .= '<ol><li>';
            $HeadingsLevel++;
        }
        $Headings .= "<a href=\"#$link\">$text</a>";
    }

    while ($HeadingsLevel > $HeadingsLevelStart) {
        $Headings .= '</li></ol>';
        $HeadingsLevel--;
    }
    return '' if $count <= 2;
    return '<div class="toc">' . $Headings . '</div>'
      if $Headings;
}
