# Copyright (C) 2004  Alex Schroeder <alex@emacswiki.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the
#    Free Software Foundation, Inc.
#    59 Temple Place, Suite 330
#    Boston, MA 02111-1307 USA

$ModulesDescription .= '<p>$Id: simple-rules.pl,v 1.12 2004/04/11 11:18:04 as Exp $</p>';

use vars qw(@MyInlineRules @MyDirtyInlineRules);

@MyInlineRules = ();
@MyDirtyInlineRules = ();

*ApplyRules = *NewRulesApplyRules;

my $PROT = "\x1c";
my $DIRT = "\x1d";

sub NewRulesApplyRules {
  # locallinks: apply rules that create links depending on local config (incl. interlink!)
  my ($text, $locallinks, $withanchors, $revision) = @_;
  # shortcut for dirty blocks (if this is the content of a real page: no caching!)
  local $counter = 0;
  local %protected = ();
  local %dirty = ();
  my $result;
  $text = RulesApplyDirtyInlineRules($text, $locallinks);
  if ($text =~ /^${DIRT}[0-9]+${DIRT}$/) { # shortcut
    $result = $text;
  } else {
    $text =~ s/[ \t]+\n/\n/g;  # no trailing whitespace to worry about
    $text =~ s/\n$//g;
    $text =~ s/^\n//g;
    my @paragraphs = split(/\n\n+/, $text);
    foreach my $block (@paragraphs) {
      if ($block =~ /^(\* .*)/s) {
	$block = RulesItems('\*', 1, 'ul', $1, $locallinks);
      } elsif ($block =~ /^(\# .*)/s) {
	$block = RulesItems('\#', 1, 'ol', $1, $locallinks);
      } elsif ($block =~ m/^#FILE ([^ \n]+)\n(.*)/s) {
	$block = RulesProtect(GetDownloadLink(
                   $OpenPageName, (substr($1, 0, 6) eq 'image/'), $revision));
      } else {
	$block = RulesProtect('<p>') . $block . RulesProtect('</p>');
      }
      ($block =~ s/(\&lt;journal(\s+(\d*))?(\s+"(.*)")?(\s+(reverse))?\&gt;)/
       my ($str, $num, $regexp, $reverse) = ($1, $3, $5, $7);
       RulesDirty($str, sub { PrintJournal($num, $regexp, $reverse)});/ego);
      $result .= RulesApplyInlineRules($block);
    }
  }
  return RulesMungeResult($result);
}

sub RulesItems {
  my ($sep, $level, $list_tag, $text, $locallinks) = @_;
  my $mark = '(^|\n)\n*' . $sep x $level . ' +';
  my $nextmark = '\n' . $sep x ($level + 1)  . ' ';
  my @items = split(/$mark/, $text);
  shift(@items) unless @items[0]; # skip empty leading field
  $text = RulesApplyInlineRules(@items[0], $locallinks)
    . "<$list_tag>"
    . join('', # avoid extra space in CGI.pm code
	   map{
	     my $item = $_;
	     if ($item =~ /$nextmark/) {
	       $item = RulesItems($sep, $level +1, $list_tag, $item, $locallinks)
	     }
	     $q->li(RulesApplyInlineRules($item, $locallinks));
	   }
	   @items[1..$#items])
    . "</$list_tag>";
  $text = RulesProtect($text) if $level = 1;
  return $text;
}

sub RulesApplyInlineRules {
  my ($block, $locallinks) = @_;
  $_ = RulesApplyDirtyInlineRules($block, $locallinks);
  s/$UrlPattern/RulesProtect($q->a({-href=>$1}, $1))/seg;
  s/~(\S+)~/RulesProtect($q->em($1))/eg;
  s/\*\*(.+?)\*\*/RulesProtect($q->strong($1))/seg;
  s/\/\/(.+?)\/\//RulesProtect($q->em($1))/seg;
  s/\_\_(.+?)\_\_/RulesProtect($q->u($1))/seg;
  s/\*(.+?)\*/RulesProtect($q->b($1))/seg;
  s/\/(.+?)\//RulesProtect($q->i($1))/seg;
  s/\_(.+?)\_/RulesProtect($q->u($1))/seg;
  foreach my $sub (@MyInlineRules) {
    eval { local $SIG{__DIE__}; &$sub($_, $locallinks) };
  }
  return $_;
}

sub RulesApplyDirtyInlineRules {
  my ($block, $locallinks) = @_;
  if ($locallinks) {
    ($block =~ s/(\[\[$FreeLinkPattern\]\])/
     my ($str, $link) = ($1, $2);
     RulesDirty($str, GetPageOrEditLink($link,0,0,1))/ego);
    ($block =~ s/(\[\[image:$FreeLinkPattern\]\])/
     my ($str, $link) = ($1, $2);
     RulesDirty($str, GetDownloadLink($link, 1))/ego);
  }
  return $block;
}

sub RulesProtect {
  my $html = shift;
  $counter++;
  $protected{$counter} = $html;
  return $PROT . $counter . $PROT;
}

sub RulesDirty {
  my ($str, $html) = @_;
  $counter++;
  $dirty{$counter} = $str;
  $protected{$counter} = $html;
  return $DIRT . $counter . $DIRT;
}

sub RulesMungeResult {
  my $raw = shift;
  $raw = RulesUnprotect($raw);
  # now do the dirty and clean block stuff
  my @blocks;
  my @flags;
  my $count = 0;
  my $html;
  foreach $item (split(/$DIRT([0-9]+)$DIRT/, $raw)) {
    if ($count % 2) { # deal with reference
      if ($dirty{$item}) { # dirty block
	if ($html) {
	  push (@blocks, $html); # store what we have as a clean block
	  push (@flags, 0);
	  print $html; # flush what we have
	  $html = '';
	}
	push (@blocks, $dirty{$item}); # store the raw fragment as dirty block
	push (@flags, 1);
	if (ref($protected{$item}) eq 'CODE') { # print stored html or execute code
	  &{$protected{$item}};
	} else {
	  print $protected{$item};
	}
      } else { # clean reference
	$html .= $protected{$item};
      }
    } else { # deal with normal text
      $html .= $item;
    }
    $count++;
  }
  if ($html) { # deal last bit of unprinted normal text
    print $html;
    push (@blocks, $html); # store what we have as a clean block
    push (@flags, 0);
  }
  return (join($FS, @blocks), join($FS, @flags));
}

sub RulesUnprotect {
  my $raw = shift;
  $raw =~ s/$PROT([0-9]+)$PROT/$protected{$1}/ge
    while $raw =~ /$PROT([0-9]+)$PROT/; # find recursive replacements!
  return $raw;
}
