/*  GNU Ocrad - Optical Character Recognition program
    Copyright (C) 2003, 2004 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

// Only "P1" (pbm) and "P4" (pbm RAWBITS) file formats are recognized.

class Bitmap
  {
  int _width;
  int _height;
  std::vector< std::vector< bool > > data;
  std::vector< Rectangle > _rectangle_vector;

  int  find_columns( int rindex ) throw();
  bool find_rows_and_columns() throw();
  void mirror_diagonal() throw();
  void mirror_left_right() throw();
  void mirror_top_bottom() throw();
  static void floodfill4( const Bitmap & source, Bitmap & dest,
                          int row, int col ) throw();
public:
  struct Error
    {
    const char * s;
    Error( const char * p ) { s = p; }
    };

  enum Type { vertical_histogram, horizontal_histogram, connected_ground };

  // Creates a Bitmap from a pbm file
  Bitmap( FILE * f, bool invert ) throw( Error );
  // Creates a Bitmap from another Bitmap
  Bitmap( const Bitmap & source, const Rectangle & r ) throw();
  // Creates a reduced bitmap
  Bitmap( const Bitmap & source, int scale, int th ) throw();
  // Creates a "special" type of Bitmap
  Bitmap( const Bitmap &, Type ) throw( Error );

  int width()  const throw() { return _width;  }
  int height() const throw() { return _height; }
  bool get_bit( int row, int col ) const throw() { return data[row][col]; }

  const std::vector< Rectangle > & rectangle_vector() const throw()
    { return _rectangle_vector; }
  int rectangles() const throw() { return _rectangle_vector.size(); }

  int  analyse_layout( int layout_level ) throw();
  bool only_this_rectangle( int i ) throw();
  void save( FILE *, char filetype = '4' ) const throw();
  void transform( const Transformation & t ) throw();
  };
