/*  GNU OCRAD - Optical Character Recognition program
    Copyright (C) 2003 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

class Features
  {
  const Block * _block;		// Block to witch this features belong
  const Blockmap * _blockmap;	// Blockmap to which the block belongs
  mutable int _hbars, _vbars;
  mutable bool hscan_valid, vscan_valid;
  mutable std::vector< Rectangle > _hbar, _vbar;
  mutable std::vector< int > _hscan, _vscan;

public:
  mutable Profile lp, tp, rp, bp, hp, wp;

  Features( const Block & b ) throw();

  const Block * block() const throw() { return _block; }
  const Blockmap * blockmap() const throw() { return _blockmap; }

  const Rectangle & hbar( int i ) const throw() { return _hbar[i]; }
  const Rectangle & vbar( int i ) const throw() { return _vbar[i]; }
  int hbars() const throw();
  int vbars() const throw();

  const std::vector< int > & hscan() const throw();
  const std::vector< int > & vscan() const throw();

  unsigned char test_235Esz() const throw();
  unsigned char test_49egpq() const throw();
  unsigned char test_6abd() const throw();
  unsigned char test_CEFIJLlT() const throw();
  unsigned char test_c() const throw();
  unsigned char test_frst() const throw();
  unsigned char test_G() const throw();
  unsigned char test_HKMNUuvwYy() const throw();
  unsigned char test_hnw() const throw();

  bool test_comma() const throw();
  unsigned char test_line( int charbox_vcenter ) const throw();
  unsigned char test_solid( int charbox_vcenter ) const throw();
  unsigned char test_misc() const throw();
  };
