/*  ocrad - Optical Character Recognition program
    Copyright (C) 2003 Antonio Diaz Diaz.
*/

class Textline
  {
  mutable std::vector< Character > data;

public:
  Textline() throw() {}

  void add_character( const Character & c ) throw();
  void insert_character( const int, const Character & ) throw( Internal_error );
  void delete_character( const int ) throw( Internal_error );
  void swap_characters( const int, const int ) throw( Internal_error );
  Character & character( const int ) const throw( Internal_error );

  int characters() const throw() { return data.size(); }
  int mean_height() const throw();
  int mean_width() const throw();
  int mean_gap_width() const throw();
  int mean_hcenter() const throw();
  int mean_vcenter() const throw();

  void join( Textline & l ) throw();
  void print( FILE * outfile, const bool graph, const bool recursive ) const throw();
  void recognize1() const throw();
  void recognize2() throw();
  };
