/*  ocrad - Optical Character Recognition program
    Copyright (C) 2003 Antonio Diaz Diaz.
*/

class Rectangle
  {
  int _left, _top, _right, _bottom;

public:
  Rectangle( const int l, const int t, const int r, const int b )
                                          throw( Internal_error );

  int left()   const throw() { return _left;   }
  int top()    const throw() { return _top;    }
  int right()  const throw() { return _right;  }
  int bottom() const throw() { return _bottom; }

  void left  ( const int ) throw( Internal_error );
  void top   ( const int ) throw( Internal_error );
  void right ( const int ) throw( Internal_error );
  void bottom( const int ) throw( Internal_error );

  int height() const throw() { return _bottom - _top + 1; }
  int width()  const throw() { return _right - _left + 1; }

  int hcenter() const throw() { return ( _left + _right ) / 2; }
  int vcenter() const throw() { return ( _top + _bottom ) / 2; }

  void add_point( const int row, const int col ) throw();
  void add_rectangle( const Rectangle & r ) throw();

  bool includes( const Rectangle & r ) const throw();
  bool includes_hcenter( const Rectangle & r ) const throw();
  bool includes_vcenter( const Rectangle & r ) const throw();
  };
