/*  ocrad - Optical Character Recognition program
    Copyright (C) 2003 Antonio Diaz Diaz.
*/

class Profile
  {
public:
  enum type { left, top, right, bottom, height, width, zheight, zwidth };

private:
  const Block * _block;		// Block to witch this profile belongs
  const Blockmap * _blockmap;	// Blockmap to which the block belongs
  type _type;
  bool valid, valid_mean, valid_range, valid_isconcave, valid_isconvex;
  bool valid_isflat, valid_isflats, valid_ispit, valid_isvpit;
  bool valid_istip, valid_isctip;
  int limit, _mean, _range;
  bool _isconcave, _isconvex, _isflat, _isflats, _ispit, _isvpit;
  bool _istip, _isctip;
  std::vector< int > data;
  void initialize() throw();
  int mean() throw();

public:
  Profile( const Block & b, type t ) throw();

  const Block * block() const throw() { return _block; }
  const Blockmap * blockmap() const throw() { return _blockmap; }

  int samples() const throw() { return data.size(); }
  int range() throw();
  int operator[]( int i ) throw();

//  bool equal( Profile & ) throw();
  bool increasing( int i = 1 ) throw();
  bool decreasing( int i = 1 ) throw();
//  bool isconcave() throw();
  bool isconvex() throw();
  bool isflat() throw();
  bool isflats() throw();
  bool ispit() throw();
  bool isvpit() throw();
  bool istip() throw();
  bool isctip() throw();
  int  imaximum() throw();
  int  iminimum() throw();
  int  maxima() throw();
  int  minima( int th = -1 ) throw();
  bool straight( int & ) throw();
  };
