/*  ocrad - Optical Character Recognition program
    Copyright (C) 2003 Antonio Diaz Diaz.
*/

class Features
  {
  const Block * _block;		// Block to witch this features belong
  const Blockmap * _blockmap;	// Blockmap to which the block belongs
  mutable int _hbars, _vbars;
  mutable bool hscan_valid, vscan_valid;
  mutable std::vector< Rectangle > _hbar, _vbar;
  mutable std::vector< int > _hscan, _vscan;

public:
  mutable Profile lp, tp, rp, bp, hp, wp, zhp, zwp;

  Features( const Block & b ) throw();

  const Block * block() const throw() { return _block; }
  const Blockmap * blockmap() const throw() { return _blockmap; }

  const Rectangle & hbar( int i ) const throw() { return _hbar[i]; }
  const Rectangle & vbar( int i ) const throw() { return _vbar[i]; }
  int hbars() const throw();
  int vbars() const throw();

  const std::vector< int > & hscan() const throw();
  const std::vector< int > & vscan() const throw();

  bool escape_left  ( int row, int col ) const throw();
  bool escape_top   ( int row, int col ) const throw();
  bool escape_right ( int row, int col ) const throw();
  bool escape_bottom( int row, int col ) const throw();
  int seek_left  ( int row, int col ) const throw();
  int seek_top   ( int row, int col ) const throw();
  int seek_right ( int row, int col ) const throw();
  int seek_bottom( int row, int col ) const throw();

  char test_235sz() const throw();
  char test_hn() const throw();
  char test_line() const throw();
  };
