/*  ocrad - Optical Character Recognition program
    Copyright (C) 2003 Antonio Diaz Diaz.
*/

class Bitmap;


class Blockmap
  {
  int _height;
  int _width;
  std::vector< std::vector< int > > data;

  // List of clusters of black bits (Blocks), possibly containing
  // one or more blocks of white bits (holes).
  // The blocks are (more or less) ordered by position from top to bottom,
  // and then from left to right.
  std::list< Block > _block_list;

  void create_block( const Rectangle & r, const int id ) throw();
  void delete_block( const int id ) throw( Internal_error );
  void join_blocks( int id1, int id2 ) throw( Internal_error );
  void add_point_to_block( const int row, const int col, const int id ) throw( Internal_error );

public:
  int left_neighbor  ( const Rectangle & r , const int distance ) const throw();
  int top_neighbor   ( const Rectangle & r , const int distance ) const throw();
  int right_neighbor ( const Rectangle & r , const int distance ) const throw();
  int bottom_neighbor( const Rectangle & r , const int distance ) const throw();

  Blockmap( const Bitmap & source, const int debug_level ) throw( Internal_error );

  int height() const throw() { return _height; }
  int width()  const throw() { return _width;  }
  int id( const int row, const int col ) const throw() { return data[row][col]; }
  const std::list< Block > & block_list() const throw() { return _block_list; }
  };
