/*  ocrad - Optical Character Recognition program
    Copyright (C) 2003 Antonio Diaz Diaz.
*/

class Blockmap;

class Block : public Rectangle
  {
  std::list< Block > _block_list; // list of blocks nested into this one
  const Blockmap * _blockmap;	// Blockmap to which this block belongs
  int _id;			// block identification number
				// positive for block of black dots
				// negative for block of white dots
public:
  Block( const Rectangle & r, const Blockmap & b, const int id ) throw()
    : Rectangle( r ), _blockmap( &b ), _id( id ) {}

  int area() const throw();
  const std::list< Block > & block_list() const throw() { return _block_list; }
  const Blockmap * blockmap() const throw() { return _blockmap; }
  int id() const throw() { return _id; }
  bool compare_id( const int id, const bool recursive ) const throw();
  void print( FILE * outfile, const int sp ) const throw();

  friend void hierarchize_blocks( std::list< Block > & block_list ) throw();
  };
