/*  ocrad - Optical Character Recognition program
    Copyright (C) 2003 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <cstdio>
#include <list>
#include <vector>
#include "common.h"
#include "rectangle.h"
#include "block.h"
#include "blockmap.h"


// Return the area of this block only (no recursive)
int Block::area() const throw()
  {
  int area = 0;

  for( int row = top(); row <= bottom(); ++row )
    for( int col = left(); col <= right(); ++col )
      if( _blockmap->id( row, col ) == id() ) ++area;

  return area;
  }


bool Block::compare_id( const int id, const bool recursive ) const throw()
  {
  if( id == _id ) return true;
  if( recursive )
    {
    std::list< Block >::const_iterator p = _block_list.begin();
    for( ; p != _block_list.end(); ++p )
      if( p->compare_id( id, recursive ) ) return true;
    }
  return false;
  }


void Block::print( FILE * outfile, const int sp ) const throw()
  {
  char ch = _id > 0 ? 'O' : '-';
  for( int row = top(); row <= bottom(); ++row)
    {
    for( int i = 0; i < sp; ++i ) fputc( ' ', outfile );
    for( int col = left(); col <= right(); ++col)
      {
      if( _blockmap->id( row, col ) == _id )
        fprintf( outfile, " %c", ch );
      else fprintf( outfile, " " );
      }
    fprintf( outfile, "\n" );
    }
  fprintf( outfile, "\n" );

  if( sp >= 0 )
    {
    std::list< Block >::const_iterator p = _block_list.begin();
    for( ; p != _block_list.end(); ++p )
      p->print( outfile, sp + 8 );
    }
  }
