/*  ocrad - Optical Character Recognition program
    Copyright (C) 2003 Antonio Diaz Diaz.
*/

// Only "P1" (pbm) and "P4" (pbm RAWBITS) file formats are recognized.

class Bitmap
  {
  int _width;
  int _height;
  std::vector< std::vector< bool > > data;
  std::vector< Rectangle > _rectangle_list;
public:
  struct Error
    {
    const char * s;
    Error( const char * p ) { s = p; }
    };

  enum type { vertical_histogram, horizontal_histogram, connected_ground };

  Bitmap( FILE * );			// Creates a Bitmap from a pbm file
  // Creates a Bitmap from another Bitmap
  Bitmap( const Bitmap & source, const Rectangle & r );
  // Creates a reduced bitmap
  Bitmap( const Bitmap & source, int th, const int scale );
  Bitmap( const Bitmap &, const type );	// Creates a "special" type of Bitmap

  int width()  const throw() { return _width;  }
  int height() const throw() { return _height; }
  bool get_bit( const int row, const int col ) const throw()
    { return data[row][col]; }
  const std::vector< Rectangle > & rectangle_list() const throw()
    { return _rectangle_list; }
  int find_columns( const bool verbose = false );
  int horizontalify( const bool verbose = false );
  void save( FILE *, char filetype = '4' );

  friend void floodfill4( const Bitmap & source, Bitmap & dest,
			const int row, const int col );
  };
