def replace_quotation_marks(filename):
    # Define a list of quotation mark pairs
    quotation_marks_options = [
        ("„", "“"),  # Option 1
        ("«", "»"),  # Option 2
        ("‘", "’"),  # Option 3
        ("「", "」")  # Option 4
    ]

    # Present the options to the user
    print("Choose the kind of quotation marks by entering the corresponding number:")
    for i, marks in enumerate(quotation_marks_options, start=1):
        print(f"{i}. {marks[0]}…{marks[1]}")

    # Get the user's choice
    choice = int(input("Your choice (1-4): ")) - 1
    if choice < 0 or choice >= len(quotation_marks_options):
        print("Invalid choice. Exiting.")
        return

    new_quotes = quotation_marks_options[choice]

    # Construct the full file path with the fixed path and the user-provided language code
    file_path = f"../../../po/{language_code}.po"

    replacement_count = 0  # Initialize the counter for replacements

    try:
        with open(file_path, 'r', encoding='utf-8') as file:
            lines = file.readlines()

        updated_lines = []
        for line in lines:
            if 'msgstr' in line:
                opening_quote_index = line.find('"')
                closing_quote_index = line.rfind('"')
                if opening_quote_index != -1 and closing_quote_index > opening_quote_index:
                    inner_string = line[opening_quote_index+1:closing_quote_index]
                    line_replacements = 0
                    new_inner_string = inner_string
                    while '\\"' in new_inner_string:
                        new_inner_string = new_inner_string.replace('\\"', new_quotes[0], 1)
                        if '\\"' in new_inner_string:
                            new_inner_string = new_inner_string.replace('\\"', new_quotes[1], 1)
                            line_replacements += 1
                        else:
                            break

                    if line_replacements > 0:
                        replacement_count += line_replacements
                        line = line[:opening_quote_index+1] + new_inner_string + line[closing_quote_index:]

            updated_lines.append(line)

        with open(file_path, 'w', encoding='utf-8') as file:
            file.writelines(updated_lines)

        if replacement_count > 0:
            print(f"Quotation marks replaced successfully in {replacement_count} pairs.")
        else:
            print("No replacements were made because no suitable \" \" pairs were found.")

    except FileNotFoundError:
        print(f"Error: The file at {file_path} was not found.")
    except Exception as e:
        print(f"An error occurred: {e}")

# Example usage
if __name__ == '__main__':
    language_code = input("Enter the language code (like zh_CN): ")
    replace_quotation_marks(language_code)
