/*
--          This file is part of the New World OS and Objectify projects
--               Copyright (C) 2007, 2008, 2009, 2010  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2010-01-17 15:01:51 -0700 (Sun, 17 Jan 2010) $
--   $Revision: 4463 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
*/


#include <assert.h>
#include <stdio.h>

#include "crc32.h"
#include "objectify.h"


int main(int argc, char* argv[])
{
    C_struct_Person person_obj;
    ObjRef object_class;
    EveryObject class_ref_header;
    ObjRef person_class_ref;
    ReferenceList* ref_list;
    int num_refs;
    int i;
    char name[32];
    char temp[16];
    int count;

    nwos_log_arguments(argc, argv);

    nwos_initialize_objectify(PUBLIC, NULL);

    if (!nwos_find_public_class_definition("PERSON", &person_class_ref))
    {
	printf("\nThere are no persons in the system!\n\n");
	exit(1);
    }

    nwos_read_object_headers_from_disk(&person_class_ref, &class_ref_header);

    ref_list = nwos_malloc_reference_list(&class_ref_header.object.references);

    num_refs = ref_list->common_header.num_refs;

    /* printf("person class num refs: %d\n", num_refs); */

    for (i = 0; i < num_refs; i++)
    {
	nwos_get_object_class(&ref_list->references[i], &object_class);   /* find out what kind of object it is */

	if (is_same_object(&object_class, &person_class_ref))
	{
	    assert(nwos_read_object_from_disk(&ref_list->references[i], &person_obj, sizeof(person_obj)));

	    nwos_name_to_string(&person_obj.last_name, name, sizeof(name));

	    printf("%s, ", name);

	    count = strlen(name) + 2;

	    nwos_name_to_string(&person_obj.first_name, name, sizeof(name));

	    printf("%s", name);

	    count = count + strlen(name);

	    if (!is_void_reference(&person_obj.middle_name))
	    {
		nwos_name_to_string(&person_obj.middle_name, name, sizeof(name));

		printf(" %s", name);

		count = count + strlen(name) + 1;
	    }

	    if (!is_void_reference(&person_obj.birth_date))
	    {
		while (count < 30)
		{
		    putchar(' ');
		    count++;
		}
		printf("born: ");
		nwos_date_to_string(&person_obj.birth_date, temp, sizeof(temp));
		printf("%s", temp);
	    }

	    if (!is_void_reference(&person_obj.death_date))
	    {
		printf("   died: ");
		nwos_date_to_string(&person_obj.death_date, temp, sizeof(temp));
		printf("%s", temp);
	    }

	    printf("\n");
	}
    }

    nwos_free_reference_list(ref_list);
    ref_list = NULL;

    nwos_terminate_objectify();

    return 0;
}

